import {connect} from 'react-redux';
import {replace} from 'connected-react-router';
import {FamilyRedesignInvitePage as Page, INVITE_FORM_TYPES} from './FamilyRedesignInvitePage';
import {setFamilyInviteTarget, toggleFamilyNotification} from '../../actions';
import {goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {postInvite} from '../../middlewares/api/invite';
import {setFamilyInviteContact} from '../../middlewares/actions/common';
import {updateValues} from '@blocks/actions/form';

const mapStateToProps = (state = {}) => {
    const {
        family: {
            inviteId,
            inviteTarget,
            slots = [],
            loading,
            hideInvitePageBackButton = false,
            isInvitePage = false,
            notRedirectAfterInvite
        } = {},
        settings: {host, env = {}, tld, ua = {}} = {},
        form: {values} = {}
    } = state;
    const envToHost = {
        testing: `https://id-test.yandex.${tld}`,
        production: `https://id.yandex.${tld}`,
        rc: host,
        development: host
    };

    return {
        inviteLink: inviteId ? `${envToHost[env.type || 'production']}/profile/family/invite/${inviteId}` : null,
        inviteInputValue: values.family_invite_input,
        inviteTarget,
        defaultInviteTarget: ua.isMobile ? INVITE_FORM_TYPES[1] : INVITE_FORM_TYPES[0],
        slots,
        loading,
        hideBackButton: isInvitePage && hideInvitePageBackButton,
        notRedirectAfterInvite
    };
};

const mapDispatchToProps = {
    setFamilyInviteTarget,
    setFamilyInviteContact,
    toggleFamilyNotification,
    fetchFamily,
    postInvite,
    goToMainPage,
    updateValues,
    replaceHistory: replace
};

export const FamilyRedesignInvitePage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilyRedesignInvitePage;
