import {connect} from 'react-redux';
import {FamilySlotInfoPage as Page} from './FamilySlotInfoPage';
import {goToPage, goToKiddishPage, goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {postUsersLimits, postFillBalance} from '../../middlewares/api/pay';
import {updateCurrentSlot, setCurrentSlot} from '../../middlewares/actions/common';
import {updatePayLimitForm, resetPayLimitsForm} from '../../middlewares/actions/pay';

import {toggleFamilyNotification} from '@blocks/morda/new/family/actions';
import {LIMIT_MODES} from '../../const';

const mapStateToProps = (state) => {
    const {
        family: {
            hideMembersBackButton = false,
            isMemberPage = false,
            isAdminAccess = false,
            loading = false,
            yourSlot = {},
            currentSlot = {},
            currentSlotLimitInfo = {},
            pay: {cardInfo: {bound = false} = {}} = {},
            isWebview = false
        } = {},
        settings: {language, passportLinks = {}} = {},
        common: {retpath} = {}
    } = state;
    const hideBackButton = hideMembersBackButton && isMemberPage;
    const {
        balance,
        currency,
        isCardActualyEnabled,
        limit: {limitMode = LIMIT_MODES.DAY, value: limitValue} = {}
    } = currentSlotLimitInfo;

    return {
        bound,
        loading,
        language,
        isCardActualyEnabled,
        passportLinks,
        currency,
        yourSlot,
        currentSlot,
        balance,
        limitMode,
        limitValue,
        isAdminAccess,
        hideBackButton,
        retpath,
        isWebview
    };
};

const mapDispatchToProps = {
    goToPage,
    goToMainPage,
    goToKiddishPage,
    updatePayLimitForm,
    updateCurrentSlot,
    postUsersLimits,
    postFillBalance,
    resetPayLimitsForm,
    setCurrentSlot,
    toggleFamilyNotification,
    fetchFamily
};

export const FamilySlotInfoPage = connect(mapStateToProps, mapDispatchToProps)(Page);
export default FamilySlotInfoPage;
