import React from '@plibs/react';
import PropTypes from 'prop-types';
import {FamilyActionLayout} from '@blocks/morda/new/family/layouts/FamilyActionLayout';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS} from '@blocks/constants';
import {ACCEPT_INVITE_TEXTS} from '@blocks/morda/new/family/const';

export class FamilyWelcomePage extends React.Component {
    onClose = () => {
        const {goToMainPage, isWebview, retpath} = this.props;

        if (isWebview && retpath) {
            return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
        }

        goToMainPage();
    };

    render() {
        const {hasFamilyCardBound} = this.props;
        // TODO еще текст В семье можно пользоваться преимуществами
        //  Плюса и общей картой, создавать детские профили

        return (
            <FamilyActionLayout
                hideBackButton={true}
                decor='welcome'
                title={ACCEPT_INVITE_TEXTS.titles.welcome}
                text={hasFamilyCardBound ? ACCEPT_INVITE_TEXTS.texts.welcome : ACCEPT_INVITE_TEXTS.texts.welcomeNoPay}
                buttons={[
                    {
                        text: ACCEPT_INVITE_TEXTS.buttons.perfect,
                        view: 'action',
                        metric: ['Нажатие на кнопку "Отлично"'],
                        onClick: this.onClose
                    }
                ]}
            />
        );
    }
}

FamilyWelcomePage.propTypes = {
    isWebview: PropTypes.bool,
    hasFamilyCardBound: PropTypes.bool,
    goToMainPage: PropTypes.func,
    retpath: PropTypes.string
};
