import {
    SET_FAMILY_SLOTS,
    SET_FAMILY_CURRENT_SLOT,
    UPDATE_FAMILY_CURRENT_SLOT,
    SET_FAMILY_LOADING,
    SET_FAMILY_ERROR,
    SET_FAMILY_INVITE,
    SET_FAMILY_INVITE_TARGET,
    SET_FAMILY_INVITE_CONFIRMED,
    SET_FAMILY_INVITE_CONTACT,
    SET_FAMILY_MEMBER_EXCLUDED,
    SET_FAMILY_INFO,
    SET_FAMILY_ADMIN_ACCESS,
    SET_FAMILY_INVITE_ID,
    SET_FAMILY_SUBSCRIPTION,
    ADD_FAMILY_INVITE,
    REMOVE_FAMILY_INVITE,
    SET_FAMILY_PAGE,
    SET_FAMILY_OFFER,
    SET_FAMILY_OFFER_LOADING,
    SET_FAMILY_PAY,
    ADD_FAMILY_KIDDISH,
    REMOVE_FAMILY_KIDDISH,
    CHANGE_FAMILY_SLOT,
    SET_PAY_SETTINGS_OPENED,
    SET_PAY_LIMIT_FORM,
    UPDATE_PAY_LIMIT_FORM,
    UPDATE_PAY_LIMIT_CURRENT_SLOT_BALANCE,
    SET_3DS_STATE,
    SET_CHILDISH_RATING,
    TOGGLE_FAMILY_NOTIFICATION,
    SET_KIDDISH_FIELD_ERROR
} from './actions';
import {KIDDISH_AVATARS_PROD, KIDDISH_AVATARS_TEST, SLOTS_GROUP_TYPES, MAX_LIMIT, PAY_SERVICES} from './const';

const defaultState = {
    hasFamilySubscription: false,
    currentSlot: {isEmpty: true},
    inviteTarget: '',
    familyId: null,
    hasFamily: false,
    loading: false,
    error: null,
    inviteId: null,
    inviteContact: null,
    inviteConfirmed: false,
    isAdminAccess: false,
    familyCapacity: 0,
    kiddishCapacity: 0,
    slots: [],
    kiddishSlots: null,
    familyOffer: {text: i18n('Plus.subscribe'), subText: '', familyId: ''},
    isFamilyOfferLoading: false,
    hideServices: false,
    notification: {
        isVisible: false,
        text: '',
        iconType: '',
        theme: 'default'
    },
    kiddishFieldsErrors: {}
};

const setEmptySlot = (slots, index) => {
    const newSlots = slots.slice();

    if (index !== -1) {
        newSlots.splice(index, 1);
    }
    return newSlots;
};

const replaceEmptySlot = (slots, capacity, slot) => {
    const newSlots = slots.slice();
    const emptySlotIndex = newSlots.findIndex((slot) => slot.isEmpty);

    if (emptySlotIndex !== -1) {
        newSlots[emptySlotIndex] = slot;
        if (newSlots.length < capacity) {
            newSlots.push({isEmpty: true});
        }
    }

    return newSlots;
};

const addEmptySlots = (slots, capacity) => (slots.length < capacity ? [...slots, {isEmpty: true}] : slots.slice());

const updatePayLimitFormUser = (user = {}, placeId = '', newUser = {}) =>
    user.placeId === placeId ? {...user, ...newUser} : user;

const changeSlot = (slot = {}, placeId = '', newSlot = {}) => (slot.placeId === placeId ? {...newSlot} : slot);

export default function(state = defaultState, action = {}) {
    const {type, payload} = action;

    switch (type) {
        case SET_FAMILY_LOADING:
            return Object.assign({}, state, {loading: payload});
        case UPDATE_FAMILY_CURRENT_SLOT:
            return Object.assign({}, state, {currentSlot: {...state.currentSlot, ...payload}});
        case SET_FAMILY_ERROR:
            return Object.assign({}, state, {error: payload});
        case SET_FAMILY_INVITE:
            return Object.assign({}, state, {invite: payload});
        case SET_FAMILY_INVITE_CONFIRMED:
            return Object.assign({}, state, {isInviteConfirmed: true});
        case SET_FAMILY_INVITE_ID:
            return Object.assign({}, state, {inviteId: payload});
        case SET_FAMILY_INVITE_CONTACT:
            return Object.assign({}, state, {inviteContact: payload});
        case SET_FAMILY_SUBSCRIPTION:
            return Object.assign({}, state, {hasFamilySubscription: payload});
        case SET_FAMILY_OFFER:
            return Object.assign({}, state, {familyOffer: payload});
        case SET_FAMILY_OFFER_LOADING:
            return Object.assign({}, state, {isFamilyOfferLoading: payload});
        case SET_PAY_SETTINGS_OPENED:
            return Object.assign({}, state, {isPaySettingsOpened: payload});
        case SET_FAMILY_PAY: {
            const pay = payload || {};
            const usersInfoByPlaceId = {};

            if (pay.usersInfo && Array.isArray(pay.usersInfo)) {
                pay.usersInfo.forEach((userInfo) => {
                    Object.assign(userInfo, {
                        allowAllServices: userInfo.allowAllServices || false,
                        allowedServices: userInfo.allowAllServices ? [] : userInfo.allowedServices,
                        isCardActualyEnabled:
                            userInfo.isEnabled &&
                            (userInfo.allowAllServices ||
                                Object.keys(PAY_SERVICES).some((service) => userInfo.allowedServices.includes(service)))
                    });
                    usersInfoByPlaceId[userInfo.placeId] = userInfo;
                });
            }
            return Object.assign({}, state, {pay: {...pay, usersInfoByPlaceId}});
        }
        case SET_3DS_STATE:
            return Object.assign({}, state, {is3dsSuccess: payload});
        case SET_FAMILY_CURRENT_SLOT: {
            const {isUser = false, placeId} = payload;
            const {memberSlots = [], pay: {usersInfo = []} = {}, payLimitsForm = []} = state;

            return Object.assign({}, state, {
                currentSlot: payload,
                currentSlotLimitInfo: usersInfo.find((user) => user.placeId === placeId) || usersInfo[0],
                currentSlotFormLimitInfo:
                    payLimitsForm.find((userInfo) => userInfo.placeId === placeId) || payLimitsForm[0],
                currentSlotUserIndex: isUser ? memberSlots.findIndex((slot) => placeId === slot.placeId) : 0
            });
        }
        case SET_PAY_LIMIT_FORM: {
            const {
                yourSlot = {},
                currentSlot = {},
                hasLimitPreFilled = false,
                preFilledLimitValue = 0,
                preFilledLimitMode = 'DAY'
            } = state;

            let updatedUsersInfo = null;

            if (hasLimitPreFilled) {
                updatedUsersInfo = payload.forEach((userInfo) => {
                    if (userInfo.placeId === currentSlot.placeId && userInfo.limit) {
                        const oldValue = userInfo.limit.value;
                        const newValue =
                            preFilledLimitMode === 'NOLIMIT'
                                ? oldValue
                                : Math.min(oldValue + preFilledLimitValue, MAX_LIMIT);

                        userInfo.limit.value = newValue;
                        userInfo.limit.limitMode = preFilledLimitMode;
                    }
                });
            }

            return Object.assign({}, state, {
                payLimitsForm: updatedUsersInfo || payload,
                currentSlotFormLimitInfo: (updatedUsersInfo || payload).find(
                    (userInfo) => userInfo.placeId === currentSlot.placeId
                ),
                yourSlotLimitInfo: (updatedUsersInfo || payload).find(
                    (userInfo) => userInfo.placeId === yourSlot.placeId
                ),
                hasLimitPreFilled: false
            });
        }
        case UPDATE_PAY_LIMIT_FORM: {
            const {yourSlotLimitInfo = {}, currentSlotFormLimitInfo = {}, payLimitsForm = []} = state;
            const {placeId} = payload;

            return Object.assign({}, state, {
                payLimitsForm: payLimitsForm.map((userInfo) => updatePayLimitFormUser(userInfo, placeId, payload)),
                currentSlotFormLimitInfo: updatePayLimitFormUser(currentSlotFormLimitInfo, placeId, payload),
                yourSlotLimitInfo: updatePayLimitFormUser(yourSlotLimitInfo, placeId, payload)
            });
        }
        case UPDATE_PAY_LIMIT_CURRENT_SLOT_BALANCE: {
            const {currentSlotLimitInfo = {}} = state;
            const {
                limit: {value: maxBalance = 0}
            } = currentSlotLimitInfo;

            return Object.assign({}, state, {
                currentSlotLimitInfo: {...currentSlotLimitInfo, balance: maxBalance}
            });
        }
        case SET_FAMILY_PAGE: {
            const {page = null, modal = null} = payload;

            return Object.assign({}, state, {pageInfo: {page, modal}});
        }
        case SET_FAMILY_SLOTS: {
            const {members = [], kids = [], invites = []} = payload;
            const memberSlots = members.map((member) => ({...member, isUser: true}));
            const inviteSlots = invites.map((invite) => ({...invite, isInvite: true}));
            const membersWithoutAdmin = memberSlots.filter((slot) => !slot.isAdmin);

            return Object.assign({}, state, {
                slots: memberSlots.concat(inviteSlots),
                memberSlots,
                inviteSlots,
                membersIsNotAbleToUsePaySlots: memberSlots.filter((slot) => !slot.isAbleToUsePay),
                membersAndEmptySlots: memberSlots.concat({isEmpty: true}),
                membersWithoutAdminSlots: membersWithoutAdmin,
                membersWithoutAdminAndEmptySlots: membersWithoutAdmin.concat({isEmpty: true}),
                kiddishSlots: kids.map((kiddish) => ({...kiddish, isKiddish: true})),
                slotsCountByGroup: {
                    [SLOTS_GROUP_TYPES.MEMBER]: members.length + invites.length,
                    [SLOTS_GROUP_TYPES.KIDDISH]: kids.length
                },
                yourSlot: memberSlots.find((member) => member.isYou),
                adminSlot: memberSlots.find((member) => member.isAdmin),
                hasMembers: members.length > 1
            });
        }
        case SET_FAMILY_MEMBER_EXCLUDED: {
            const {slots = []} = state;

            return Object.assign({}, state, {
                slots: setEmptySlot(
                    slots,
                    slots.findIndex((slot) => slot.placeId === payload)
                )
            });
        }
        case SET_FAMILY_ADMIN_ACCESS: {
            const {slots = [], kiddishSlots = [], familyCapacity, kiddishCapacity} = state;

            return Object.assign({}, state, {
                isAdminAccess: payload,
                slots: payload ? addEmptySlots(slots, familyCapacity) : slots,
                kiddishSlots: addEmptySlots(kiddishSlots, kiddishCapacity)
            });
        }
        case SET_FAMILY_INFO: {
            const {familyId, familyCapacity, kiddishCapacity, hasFamilySubscription, envType} = payload;

            return Object.assign({}, state, {
                familyId,
                familyCapacity,
                kiddishCapacity,
                kiddishAvatars: ['development', 'testing'].includes(envType)
                    ? KIDDISH_AVATARS_TEST
                    : KIDDISH_AVATARS_PROD,
                hasFamilySubscription,
                hasFamily: Boolean(familyId)
            });
        }
        case ADD_FAMILY_INVITE: {
            const {slots, familyCapacity} = state;
            const {inviteId, inviteContact, inviteMethod} = payload;

            return Object.assign({}, state, {
                slots: replaceEmptySlot(slots, familyCapacity, {isInvite: true, inviteId, inviteContact, inviteMethod})
            });
        }
        case SET_FAMILY_INVITE_TARGET: {
            return Object.assign({}, state, {
                inviteTarget: payload
            });
        }
        case ADD_FAMILY_KIDDISH: {
            const {kiddishSlots, kiddishCapacity} = state;

            return Object.assign({}, state, {
                kiddishSlots: replaceEmptySlot(kiddishSlots, kiddishCapacity, {
                    ...payload,
                    isKiddish: true,
                    isEmpty: false
                })
            });
        }
        case REMOVE_FAMILY_INVITE: {
            const {slots} = state;

            return Object.assign({}, state, {
                slots: setEmptySlot(
                    slots,
                    slots.findIndex((slot) => slot.inviteId === payload)
                )
            });
        }
        case REMOVE_FAMILY_KIDDISH: {
            const {kiddishSlots} = state;

            return Object.assign({}, state, {
                kiddishSlots: setEmptySlot(
                    kiddishSlots,
                    kiddishSlots.findIndex((slot) => slot.uid === payload)
                )
            });
        }
        case CHANGE_FAMILY_SLOT: {
            const {placeId, slot} = payload;
            const {slots = [], kiddishSlots = [], yourSlot = {}, adminSlot = {}} = state;

            return Object.assign({}, state, {
                slots: slots.map((oldSlot) => changeSlot(oldSlot, placeId, slot)),
                kiddishSlots: kiddishSlots.map((oldSlot) => changeSlot(oldSlot, placeId, slot)),
                yourSlot: changeSlot(yourSlot, placeId, slot),
                adminSlot: changeSlot(adminSlot, placeId, slot)
            });
        }
        case SET_CHILDISH_RATING: {
            const {rating} = payload;

            return Object.assign({}, state, {currentSlot: {...state.currentSlot, rating}});
        }
        case TOGGLE_FAMILY_NOTIFICATION: {
            return Object.assign({}, state, {
                notification: payload
            });
        }
        case SET_KIDDISH_FIELD_ERROR: {
            const {field, error} = payload;

            return Object.assign({}, state, {
                kiddishFieldsErrors: {...state.kiddishFieldsErrors, [field]: error}
            });
        }
        default:
            return state;
    }
}
