import getSymbolFromCurrency from 'currency-symbol-map';
import {CURRENCIES_BEFORE_VALUE} from '../const';

const LANG_TO_BCP47 = {
    ru: 'ru-RU',
    en: 'en-US',
    tr: 'tr-TR',
    id: 'he-IL',
    fr: 'fr-FR'
};

export const addCurrencySymbol = (value, currency, language = 'ru') => {
    const symbol = getSymbolFromCurrency(currency);
    const isValueNumber = typeof value === 'number';

    if (isValueNumber) {
        const locale = LANG_TO_BCP47[language] || 'en-US';
        const showValue = new Intl.NumberFormat(locale).format(Math.floor(value));

        return CURRENCIES_BEFORE_VALUE.includes(currency) ? `${symbol} ${showValue}` : `${showValue} ${symbol}`;
    }
    return symbol;
};

export {getSymbolFromCurrency};
