import {shortenInviteContact} from './shortenInviteContact';

export const getSlotSubtitle = ({isUser, isFake, isAdmin, isKiddish, isChildish, isInvite, inviteContact}) => {
    if (isUser && !isFake) {
        if (isChildish) {
            return i18n('Family.member.subtitle.childish');
        }
        return isAdmin ? i18n('Family.member.subtitle.admin') : i18n('Family.member.subtitle.member');
    }
    if (isKiddish) {
        return i18n('Family.member.subtitle.kiddish');
    }
    if (isInvite) {
        return shortenInviteContact(inviteContact) || i18n('Family.slots-list.invite.description');
    }
};
