import commonMetrics from '@blocks/metrics';
import {METRIC_PREFIXES} from '../const';

const sendFamilyMetric = (data = []) => commonMetrics.send([METRIC_PREFIXES.FAMILY, ...data]);

export const metrics = {
    send: (data = []) => sendFamilyMetric(data),
    sendKiddish: (data = []) => sendFamilyMetric([METRIC_PREFIXES.KIDDISH, ...data]),
    sendPay: (data = []) => sendFamilyMetric([METRIC_PREFIXES.PAY, ...data]),
    goal: (event = '') => commonMetrics.goal(event),
    goalPay: (event = '') => commonMetrics.goal(`familypay_${event}`)
};
