import {ACCEPT_INVITE_ROUTE_REGEX, FAMILY_ENTRY_PAGES_METRICS_MAP, ACCEPT_INVITE_WEBVIEW_ROUTE_REGEX} from '../const';
import {metrics} from './metrics';

export const sendShownPageMetric = (pathname, hasFamilySubscription, hasFamily) => {
    if (ACCEPT_INVITE_ROUTE_REGEX.test(pathname)) {
        return metrics.send([FAMILY_ENTRY_PAGES_METRICS_MAP.acceptInvite, {hasFamily, hasFamilySubscription}]);
    }

    if (ACCEPT_INVITE_WEBVIEW_ROUTE_REGEX.test(pathname)) {
        return metrics.send([FAMILY_ENTRY_PAGES_METRICS_MAP.acceptInviteWebview, {hasFamily, hasFamilySubscription}]);
    }

    return metrics.send([
        FAMILY_ENTRY_PAGES_METRICS_MAP[pathname] || FAMILY_ENTRY_PAGES_METRICS_MAP.default,
        {hasFamily, hasFamilySubscription}
    ]);
};
