import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyPaySettings} from '../../components/FamilyPaySettings';
import {LoaderId} from '@components/LoaderId';
import './FamilyPaySettings.styl';

const b = cn('FamilyPaySettingsWidget');

export class FamilyPaySettingsWidget extends React.Component {
    componentDidMount() {
        const {hasFamilyInStore, fetchFamily} = this.props;

        !hasFamilyInStore && fetchFamily();
    }
    render() {
        const {isLoading} = this.props;

        return <div className={b({isLoading})}>{isLoading ? <LoaderId /> : <FamilyPaySettings isWidget={true} />}</div>;
    }
}

FamilyPaySettingsWidget.propTypes = {
    fetchFamily: PropTypes.func.isRequired,
    isLoading: PropTypes.bool.isRequired,
    hasFamilyInStore: PropTypes.bool.isRequired
};
