import {connect} from 'react-redux';
import {fetchFamily} from '../../middlewares/api/state';
import {FamilyPaySettingsWidget as PaySettingsWidget} from './FamilyPaySettings';

const mapStateToProps = ({family: {loading, yourSlotLimitInfo} = {}}) => ({
    hasFamilyInStore: Boolean(yourSlotLimitInfo),
    isLoading: loading || !yourSlotLimitInfo
});

const mapDispatchToProps = {fetchFamily};

export const FamilyPaySettingsWidget = connect(mapStateToProps, mapDispatchToProps)(PaySettingsWidget);
