import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Popup from './popup.jsx';

const errorMessages = {
    currentPassword: {
        empty: i18n('_AUTH_.password_current_errors_missingvalue'),
        not_matched: i18n('_AUTH_.password_current_errors_not_matched'),
        found_in_history: i18n('_AUTH_.password_errors_foundinhistory')
    },
    newPassword: {
        empty: i18n('_AUTH_.password_errors_missingvalue'),
        equals_previous: i18n('_AUTH_.password_errors_equals_previous'),
        likephonenumber: i18n('_AUTH_.password_errors_likephonenumber'),
        found_in_history: i18n('_AUTH_.password_errors_foundinhistory'),
        change_forbidden: i18n('Frontend.password_errors_change_forbidden')
    },
    repeatPassword: {
        empty: i18n('_AUTH_.password_confirm_errors_missingvalue'),
        not_matched: i18n('_AUTH_.password_confirm_errors_notequal'),
        matched: i18n('Frontend.password_confirm_ok')
    },
    captcha: {
        empty: i18n('_AUTH_.errors.required'),
        not_matched: i18n('Profile.domik.captcha-not-matched'),
        cannot_locate: i18n('_AUTH_.answer_errors_captchalocate')
    }
};

export default function PasswordError(props) {
    const {error, activeError, fieldName, children, isForceShown, isForceHidden} = props;
    const content =
        children ||
        (error && !isForceHidden ? ( // eslint-disable-line no-extra-parens
            <div
                className={classnames({
                    changepass__success: error === 'matched',
                    changepass__error: error !== 'matched'
                })}
            >
                {errorMessages[fieldName][error]}
            </div>
        ) : null);

    return (
        <div data-t={`error:${fieldName}`}>
            {content && <div className='changepass__descriptor_mobile'>{content}</div>}
            <Popup visible={isForceShown || fieldName === activeError}>{content}</Popup>
        </div>
    );
}

PasswordError.propTypes = {
    error: PropTypes.string,
    activeError: PropTypes.string,
    fieldName: PropTypes.string.isRequired,
    children: PropTypes.element,
    isForceShown: PropTypes.bool,
    isForceHidden: PropTypes.bool
};
