import React from 'react';
import PropTypes from 'prop-types';

const messages = {
    complete_social: i18n('Errors.account_without_password'),
    password_change_forbidden: i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.2fa_enabled': i18n('Errors.twofa_password_change_forbidden'),
    'account.without_password': i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.disabled_with_money': i18n('_AUTH_.pdd_password_change_forbidden'),
    'account.disabled': i18n('_AUTH_.pdd_password_change_forbidden'),
    'exception.unhandled': i18n('Profile.cards.errors.internal')
};

export default function PasswordMessage({code}) {
    return (
        <div className='changepass'>
            <h2 className='section-title'>{i18n('Frontend.title.changepassword')}</h2>
            <p className='chagepass__message' dangerouslySetInnerHTML={{__html: messages[code]}} />
        </div>
    );
}

PasswordMessage.propTypes = {
    code: PropTypes.string.isRequired
};
