import React from 'react';
import {useSelector, useDispatch, shallowEqual} from 'react-redux';
import Password from './password.jsx';

const PasswordPage = React.memo(
    () => {
        const dispatch = useDispatch();
        const {
            isPhone,
            language,
            staticPath,
            retpath,
            passwordInfo,
            login,
            captcha,
            isIntranet,
            isAm,
            closeUrl
        } = useSelector(
            ({settings, common, access, person, captcha, am}) => ({
                captcha,
                login: person.login,
                retpath: common.retpath,
                isPhone: settings.isPhone,
                language: settings.language,
                staticPath: settings.staticPath,
                passwordInfo: access.passwordInfo,
                isIntranet: settings.env.name === 'intranet',
                isAm: am.isAm,
                closeUrl: am.closeUrl
            }),
            shallowEqual
        );

        return (
            <Password
                isIntranet={isIntranet}
                login={login}
                isMobileCaptcha={isPhone}
                dispatch={dispatch}
                staticPath={staticPath}
                language={language}
                retpath={retpath}
                isStrongPolicyOn={passwordInfo.strong_policy_on}
                captcha={captcha}
                isAm={isAm}
                closeUrl={closeUrl}
            />
        );
    },
    () => true
);

PasswordPage.displayName = 'PasswordPage';

export default PasswordPage;
