import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default function Popup({visible, children}) {
    return (
        <div
            className={classnames('changepass__popup', {
                changepass__popup_active: visible && children
            })}
        >
            <div className='changepass__popup-content'>{children}</div>
        </div>
    );
}

Popup.propTypes = {
    visible: PropTypes.bool.isRequired,
    children: PropTypes.oneOfType([PropTypes.element, PropTypes.arrayOf(PropTypes.element)])
};
