import {reduceTokens} from './password.js';
import metrics from '../../../../metrics';

/* eslint-disable no-invalid-this */

const fieldMetrics = {
    revoke_web_sessions: 'Отжатие галочки: сессии',
    revoke_tokens: 'Отжатие галочки: устройства',
    revoke_app_passwords: 'Отжатие галочки: пароли приложений'
};

export function sendData() {
    this.props.sendData(this.state.data);
}

export function handleDefaults(key) {
    if (this.state.data[key]) {
        metrics.send(['Смена пароля', fieldMetrics[key]]);
    }

    this.setState(({data}) => {
        const revokers = this.props.revokers;

        if (key === 'revoke_web_sessions') {
            return {
                data: Object.assign({}, data, {
                    revoke_web_sessions: !data.revoke_web_sessions
                })
            };
        }

        if (key === 'revoke_tokens') {
            return {
                data: Object.assign({}, data, {
                    revoke_other_tokens: !data.revoke_tokens,
                    revoke_other_yandex_tokens: !data.revoke_tokens,
                    revoke_tokens: !data.revoke_tokens,
                    tokens: !data.revoke_tokens ? reduceTokens(revokers.tokens) : []
                })
            };
        }

        if (key === 'revoke_app_passwords') {
            return {
                data: Object.assign({}, data, {
                    revoke_app_passwords: !data.revoke_app_passwords,
                    passTokens: !data.revoke_app_passwords ? reduceTokens(revokers.passTokens) : []
                })
            };
        }

        return {};
    }, sendData);
}

export function handleDeviceToken(token) {
    this.setState(({data}) => {
        const tokens = data.tokens.slice();
        const tokenIndex = tokens.indexOf(token);

        if (tokenIndex === -1) {
            tokens.push(token);
        } else {
            tokens.splice(tokenIndex, 1);
        }

        return {
            data: Object.assign({}, data, {
                revoke_tokens:
                    this.props.revokers.tokens.length === tokens.length &&
                    data.revoke_other_yandex_tokens &&
                    data.revoke_other_tokens,
                tokens
            })
        };
    }, sendData);
}

export function handlePassToken(token) {
    this.setState(({data}) => {
        const passTokens = data.passTokens.slice();
        const tokenIndex = passTokens.indexOf(token);

        if (tokenIndex === -1) {
            passTokens.push(token);
        } else {
            passTokens.splice(tokenIndex, 1);
        }

        return {
            data: Object.assign({}, data, {
                revoke_app_passwords: this.props.revokers.passTokens.length === passTokens.length,
                passTokens
            })
        };
    }, sendData);
}

export function handleOtherTokens(isYandex = false) {
    const key = isYandex ? 'revoke_other_yandex_tokens' : 'revoke_other_tokens';
    const anotherKey = isYandex ? 'revoke_other_tokens' : 'revoke_other_yandex_tokens';

    this.setState(
        ({data}) => ({
            data: Object.assign({}, data, {
                revoke_tokens:
                    this.props.revokers.tokens.length === data.tokens.length && !data[key] && data[anotherKey],
                [key]: !data[key]
            })
        }),
        sendData
    );
}
