import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Button} from '@components/Button';
import {Checkbox} from '@components/Checkbox';
import AnimatedToggle from '@components/AnimatedToggle/AnimatedToggle.jsx';
import * as extracted from './revoke.js';

export default class Revoke extends React.Component {
    constructor(props) {
        super(props);

        this.handleDefaults = extracted.handleDefaults.bind(this);
        this.handleDeviceToken = extracted.handleDeviceToken.bind(this);
        this.handlePassToken = extracted.handlePassToken.bind(this);
        this.handleOtherTokens = extracted.handleOtherTokens.bind(this, false);
        this.handleOtherYandexTokens = extracted.handleOtherTokens.bind(this, true);
        this.togglePasses = () => this.setState(({passwordsShown}) => ({passwordsShown: !passwordsShown}));
        this.toggleDevices = () => this.setState(({tokensShown}) => ({tokensShown: !tokensShown}));
        this.toggleOtherTokens = () => this.setState(({otherTokensShown}) => ({otherTokensShown: !otherTokensShown}));
        this.toggleOtherYandexTokens = () =>
            this.setState(({otherYandexTokensShown}) => ({
                otherYandexTokensShown: !otherYandexTokensShown
            }));
        this.state = {
            tokensShown: false,
            passwordsShown: false,
            otherTokensShown: false,
            otherYandexTokensShown: false,
            data: Object.assign({}, props.initialData)
        };
    }

    render() {
        const {default: def, tokens, passTokens, otherTokens, otherYandexTokens} = this.props.revokers;
        const data = this.state.data;
        const {close, isModal} = this.props;
        const tokensCount = tokens.length + otherYandexTokens.length + otherTokens.length;

        return (
            <div
                className={classnames('p-revoke', {
                    'p-revoke__modal': isModal
                })}
            >
                <div className='p-revoke__desc'>{i18n('Profile.logout.choose')}</div>
                {def.hasOwnProperty('revoke_tokens') && tokensCount > 0 && (
                    <div className='p-revoke__tokens' data-t='revoke:tokens'>
                        <div className='p-revoke__block'>
                            <div className='p-revoke__check'>
                                <div className='p-revoke__block_x2' key={this.state.tokensShown}>
                                    <Checkbox
                                        size='s'
                                        checked={data.revoke_tokens}
                                        onChange={() => this.handleDefaults('revoke_tokens')}
                                        label={`${i18n('Profile2.changepass.revoke.devices')}${
                                            !this.state.tokensShown ? ` (${tokensCount})` : ''
                                        }`}
                                    />
                                </div>
                                <div className='p-revoke__block_x1'>
                                    <div
                                        className='p-revoke__toggle d-link p-revoke__check-sec'
                                        onClick={this.toggleDevices}
                                    >
                                        {this.state.tokensShown
                                            ? i18n('Profile2.hide_list')
                                            : i18n('Profile2.show_list')}
                                    </div>
                                </div>
                            </div>
                            <AnimatedToggle isOpened={this.state.tokensShown}>
                                <div>
                                    {tokens.length > 0 &&
                                        tokens
                                            .filter(({token}) => Boolean(token))
                                            .map(({token, title, last, count, created}) => (
                                                <div className='p-revoke__block_sec' key={token}>
                                                    <div className='p-revoke__block_x1 p-revoke__block_flex'>
                                                        <div className='p-revoke__check-sec'>
                                                            <Checkbox
                                                                size='s'
                                                                checked={data.tokens.indexOf(token) !== -1}
                                                                onChange={() => this.handleDeviceToken(token)}
                                                                label={`${title ||
                                                                    i18n('Profile.devices.default-device')}${
                                                                    !created
                                                                        ? ''
                                                                        : ` (${i18n('Profile2.created')} ${created})`
                                                                }`}
                                                            />
                                                        </div>
                                                    </div>
                                                    {last && (
                                                        <div className='p-revoke__block_x1 p-revoke__block_desktop'>
                                                            <div className='p-revoke__check-sec p-revoke__info'>
                                                                {i18n('Profile2.last_auth')}: {last}
                                                            </div>
                                                        </div>
                                                    )}
                                                    {Number(count) > 0 && (
                                                        <div className='p-revoke__block_x1 p-revoke__block_desktop'>
                                                            <div className='p-revoke__check-sec p-revoke__info'>
                                                                {i18n('Profile2.apps.many')}: {count}
                                                            </div>
                                                        </div>
                                                    )}
                                                </div>
                                            ))}
                                    {otherYandexTokens.length > 0 && (
                                        <div className='p-revoke__block_sec' key='other_yandex_tokens'>
                                            <div className='p-revoke__check-sec'>
                                                <div className='p-revoke__block_x2'>
                                                    <Checkbox
                                                        size='s'
                                                        checked={data.revoke_other_yandex_tokens}
                                                        onChange={this.handleOtherYandexTokens}
                                                        label={i18n('Profile.devices.yandex')}
                                                    />
                                                </div>
                                                <div className='p-revoke__block_x1'>
                                                    <div
                                                        className='p-revoke__toggle d-link p-revoke__check-sec'
                                                        onClick={this.toggleOtherYandexTokens}
                                                    >
                                                        {this.state.otherYandexTokensShown
                                                            ? i18n('Profile2.hide_list')
                                                            : i18n('Profile2.show_list')}
                                                    </div>
                                                </div>
                                                <AnimatedToggle isOpened={this.state.otherYandexTokensShown}>
                                                    {otherYandexTokens.map(({id, title}) => (
                                                        <div
                                                            className='p-revoke__block_sec p-revoke__check-sec'
                                                            key={id}
                                                        >
                                                            {title}
                                                        </div>
                                                    ))}
                                                </AnimatedToggle>
                                            </div>
                                        </div>
                                    )}
                                    {otherTokens.length > 0 && (
                                        <div className='p-revoke__block_sec' key='other_tokens'>
                                            <div className='p-revoke__check-sec'>
                                                <div className='p-revoke__block_x2'>
                                                    <Checkbox
                                                        size='s'
                                                        checked={data.revoke_other_tokens}
                                                        onChange={this.handleOtherTokens}
                                                        label={i18n('Profile2.other_services')}
                                                    />
                                                </div>
                                                <div className='p-revoke__block_x1'>
                                                    <div
                                                        className='p-revoke__toggle d-link p-revoke__check-sec'
                                                        onClick={this.toggleOtherTokens}
                                                    >
                                                        {this.state.otherTokensShown
                                                            ? i18n('Profile2.hide_list')
                                                            : i18n('Profile2.show_list')}
                                                    </div>
                                                </div>
                                                <AnimatedToggle isOpened={this.state.otherTokensShown}>
                                                    {otherTokens.map(({id, title}) => (
                                                        <div
                                                            className='p-revoke__block_sec p-revoke__check-sec'
                                                            key={id}
                                                        >
                                                            {title}
                                                        </div>
                                                    ))}
                                                </AnimatedToggle>
                                            </div>
                                        </div>
                                    )}
                                </div>
                            </AnimatedToggle>
                        </div>
                    </div>
                )}
                {def.hasOwnProperty('revoke_web_sessions') && (
                    <div className='p-revoke__web' data-t='revoke:web'>
                        <div className='p-revoke__block'>
                            <div className='p-revoke__check'>
                                <Checkbox
                                    size='s'
                                    checked={data.revoke_web_sessions}
                                    onChange={() => this.handleDefaults('revoke_web_sessions')}
                                    label={i18n('Profile2.changepass.revoke.web')}
                                />
                            </div>
                        </div>
                    </div>
                )}
                {def.hasOwnProperty('revoke_app_passwords') && passTokens.length > 0 && (
                    <div className='p-revoke__app-passwords' data-t='revoke:app-passes'>
                        <div className='p-revoke__block'>
                            <div className='p-revoke__check'>
                                <div
                                    className={classnames({
                                        'p-revoke__block_x3': !passTokens.length,
                                        'p-revoke__block_x2': passTokens.length
                                    })}
                                    key={this.state.passwordsShown}
                                >
                                    <Checkbox
                                        size='s'
                                        checked={data.revoke_app_passwords}
                                        onChange={() => this.handleDefaults('revoke_app_passwords')}
                                        label={`${i18n('Profile2.changepass.revoke.passwords')}${
                                            this.state.passwordsShown ? '' : ` (${passTokens.length})`
                                        }`}
                                    />
                                </div>
                                <div className='p-revoke__block_x1'>
                                    <div
                                        className='p-revoke__toggle d-link p-revoke__check-sec'
                                        onClick={this.togglePasses}
                                    >
                                        {this.state.passwordsShown
                                            ? i18n('Profile2.hide_list')
                                            : i18n('Profile2.show_list')}
                                    </div>
                                </div>
                            </div>
                            <AnimatedToggle isOpened={this.state.passwordsShown}>
                                {passTokens.map(({token, title, created}) => (
                                    <div className='p-revoke__block_sec p-revoke__check-sec' key={token}>
                                        <Checkbox
                                            size='s'
                                            checked={data.passTokens.indexOf(token) !== -1}
                                            onChange={() => this.handlePassToken(token)}
                                            label={`${title}${
                                                !created ? '' : ` (${i18n('Profile2.created')} ${created})`
                                            }`}
                                        />
                                    </div>
                                ))}
                            </AnimatedToggle>
                        </div>
                    </div>
                )}
                <div className='p-revoke__actions'>
                    <div className='p-revoke__ready'>
                        <Button view='action' size='l' width='max' onClick={close}>
                            {i18n('Frontend.ready')}
                        </Button>
                    </div>
                </div>
            </div>
        );
    }
}

Revoke.propTypes = {
    initialData: PropTypes.object.isRequired,
    revokers: PropTypes.object.isRequired,
    sendData: PropTypes.func.isRequired,
    close: PropTypes.func.isRequired,
    isModal: PropTypes.bool.isRequired
};
