import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

const MAX_SCORE_SYMBOLS = 7;

export default class PasswordStrength extends React.Component {
    shouldComponentUpdate(nextProps) {
        if (!nextProps.lastUpdate) {
            return true;
        }

        return this.props.lastUpdate !== nextProps.lastUpdate;
    }

    render() {
        const {strength, text} = this.props;
        const length = text.length;

        let strengthScore = Math.min(length, MAX_SCORE_SYMBOLS);

        // eslint-disable-next-line no-useless-escape
        [/\d/, /[0-9.,`!@#$%^&*()":;?_+=\\|\/{}\[\]<>]/, [/[a-z]/, /[A-Z]/]].forEach(function(regexp) {
            if (Array.isArray(regexp)) {
                const match = regexp.every((r) => r.test(text));

                if (match) {
                    strengthScore += 1;
                }
            } else if (regexp.test(text)) {
                strengthScore += 1;
            }
        });
        const width = -(100 - strengthScore * 10);
        const style = {transform: `translateX(${width}%)`};

        return (
            <div>
                <div className='changepass__strength'>
                    <div
                        className={classnames('changepass__strength-inner', {
                            'changepass__strength-inner_unacceptable': strength === -1,
                            'changepass__strength-inner_weak': strength === 0,
                            'changepass__strength-inner_strong': strength === 1
                        })}
                        style={style}
                    />
                </div>
            </div>
        );
    }
}

PasswordStrength.propTypes = {
    text: PropTypes.string,
    strength: PropTypes.number.isRequired,
    lastUpdate: PropTypes.number
};
