import React from 'react';
import PropTypes from 'prop-types';

import Modal from '@components/Wrappers/Modal.jsx';
import {Link} from '@components/Link';

import {DevicesList} from '@blocks/morda/devices/devices_list.jsx';

import metrics from '@blocks/metrics';

import * as extracted from './devices.js';
import {setEditMode} from '@blocks/common/actions';
import {
    showDevicesWithSameName,
    showDisablingTokens,
    updateDevicesListToDisable,
    updateListToDisable,
    updateTokenTab
} from '@blocks/morda/devices/actions';

export default class Devices extends React.PureComponent {
    static sendMetrics() {
        metrics.send(['Устройства, сервисы и программы']);
    }

    constructor(props) {
        super(props);

        this.onLinkClick = extracted.onLinkClick.bind(this);
    }

    cancelDisabling = () => {
        const {dispatch, devices} = this.props;
        const {deviceTokens} = devices.tokens;

        if (deviceTokens) {
            dispatch(updateListToDisable());
            dispatch(showDisablingTokens({show: false, deviceId: '', deviceName: ''}));
            dispatch(updateDevicesListToDisable([]));
            dispatch(showDevicesWithSameName());
            dispatch(updateTokenTab());
        }
    };

    closeModal = () => {
        const {dispatch} = this.props;

        dispatch(setEditMode(null));
        this.cancelDisabling();
    };

    render() {
        const {edit, settings, devices, havePassword, dispatch} = this.props;

        return (
            <div data-t='pssp:devices'>
                <div className='s-block__sub s-block__sub_hl'>
                    <span onClick={Devices.sendMetrics}>
                        <Link pseudo={true} onClick={this.onLinkClick}>
                            {i18n('Profile.devices.link-text')}
                        </Link>
                    </span>
                </div>
                <div className='s-block__sub'>{i18n('Profile2.auth_places')}</div>
                <Modal
                    visible={edit === 'devices-list'}
                    zIndexGroupLevel={-0.5}
                    onCloserClick={this.closeModal}
                    dataT='devices'
                >
                    <DevicesList
                        modal={true}
                        devices={devices}
                        dispatch={dispatch}
                        settings={settings}
                        havePassword={havePassword}
                    />
                </Modal>
            </div>
        );
    }
}

Devices.propTypes = {
    dispatch: PropTypes.func.isRequired,
    settings: PropTypes.object.isRequired,
    edit: PropTypes.string,
    devices: PropTypes.object.isRequired,
    havePassword: PropTypes.bool
};
