import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import {Button} from '@components/Button';
import Modal from '@components/Wrappers/Modal.jsx';

import withMethods from '@blocks/hocs/withMethods';

import metrics from '@blocks/metrics';

import * as extracted from './global_logout.js';

const GLOBAL_LOGOUT_LINK = '/passport?origin=passport_profile&mode=logout&global=1&yu=';
const EXIT_ALL = 'Выйти на всех устройствах';

export class GlobalLogout extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            isModalOpened: false
        };
        this.showAlert = extracted.showAlert.bind(this);
        this.closeAlert = extracted.closeAlert.bind(this);
    }

    shouldComponentUpdate(nextProps, nextState) {
        return this.state.isModalOpened !== nextState.isModalOpened;
    }

    render() {
        const {yandexuid, methods, settings = {}} = this.props;
        const {ua = {}} = settings;
        const {isMobile} = ua;
        const glogoutLink = `${GLOBAL_LOGOUT_LINK}${yandexuid}`;

        return (
            <div data-t='pssp:glogout'>
                <div onClick={methods.openForm} className='s-block__sub s-block__sub_hl'>
                    <Link onClick={this.showAlert} href={glogoutLink}>
                        {i18n('Profile.globallogout.link')}
                    </Link>
                </div>
                <div className='s-block__sub'>{i18n('Profile2.persecution_mania')}</div>
                <Modal visible={this.state.isModalOpened} zIndexGroupLevel={-0.5} dataT='global-logout'>
                    <div className='p-control-modal'>
                        <div className='section-head'>
                            <h2 className='section-title'>{i18n('Profile.globallogout.alert.title')}</h2>
                        </div>
                        <div
                            className='p-control-modal-message'
                            dangerouslySetInnerHTML={{
                                __html: i18n('Profile.globallogout.alert.message')
                            }}
                        />
                        <div className='p-control-saveblock'>
                            <div className='p-control-saveblock-cell-right'>
                                <span onClick={methods.confirmForm} className='p-control-saveblock-button'>
                                    <Button
                                        view='action'
                                        size='l'
                                        type='link'
                                        url={glogoutLink}
                                        width={isMobile ? 'max' : 'auto'}
                                    >
                                        {i18n('Frontend.confirm.operation')}
                                    </Button>
                                </span>
                            </div>
                            <div className='p-control-saveblock-cell-left'>
                                <span onClick={methods.closeForm} className='p-control-saveblock-button'>
                                    <Button
                                        view='pseudo'
                                        size='l'
                                        onClick={this.closeAlert}
                                        width={isMobile ? 'max' : 'auto'}
                                    >
                                        {i18n('_AUTH_.cancel.operation')}
                                    </Button>
                                </span>
                            </div>
                        </div>
                    </div>
                </Modal>
            </div>
        );
    }
}

GlobalLogout.propTypes = {
    dispatch: PropTypes.func.isRequired,
    yandexuid: PropTypes.string.isRequired,
    methods: PropTypes.object.isRequired,
    settings: PropTypes.object
};

export default withMethods(GlobalLogout, metrics.send.bind(metrics), {
    openForm: [EXIT_ALL, 'Открыть форму'],
    confirmForm: [EXIT_ALL, 'Подтвердить'],
    cancelForm: [EXIT_ALL, 'Отменить']
});
