import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';

import metrics from '../../../metrics';

function sendMetrics() {
    metrics.send(['История входов']);
}

export default function History({authDate, authRegion, browserName}) {
    const history = [authDate, browserName, authRegion].filter((a) => a).join(', ');

    return (
        <div data-t='pssp:history'>
            <div className='s-block__sub s-block__sub_hl' onClick={sendMetrics}>
                <Link href='/profile/journal?origin=passport_profile'>{i18n('Profile.lastauth.label')}</Link>
            </div>
            {history && (
                <div className='s-block__sub'>
                    {i18n('Profile2.last_auth')}: {history}
                </div>
            )}
        </div>
    );
}

History.propTypes = {
    authDate: PropTypes.string,
    authRegion: PropTypes.string,
    browserName: PropTypes.string
};
