import React from 'react';
import PropTypes from 'prop-types';

import {Section} from '@blocks/morda/new/section/section.jsx';
import History from './history.jsx';
import Devices from './devices.jsx';
import Glogout from './global_logout.jsx';
import Logout from './logout.jsx';

export default class HistoryBlock extends React.Component {
    render() {
        const {lastAuth, dispatch, settings, common, devices, havePassword} = this.props;

        return (
            <Section
                className='p-history'
                icon='clock'
                title={i18n('Profile2.titles.history_devices')}
                isHiddenDefault={true}
            >
                <div className='s-block s-block__margin'>
                    <History
                        authDate={lastAuth.date}
                        authRegion={(lastAuth.region || {}).name}
                        browserName={(lastAuth.browser || {}).name}
                    />
                </div>
                <div className='s-block s-block__margin'>
                    <Devices
                        dispatch={dispatch}
                        settings={settings}
                        edit={common.edit}
                        devices={devices}
                        havePassword={havePassword}
                    />
                </div>
                <div className='s-block'>
                    {settings.isTouch && <Logout logoutURL={settings.logoutURL} />}
                    <Glogout yandexuid={common.yandexuid} dispatch={dispatch} edit={common.edit} settings={settings} />
                </div>
            </Section>
        );
    }
}

HistoryBlock.propTypes = {
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    devices: PropTypes.object.isRequired,
    lastAuth: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    havePassword: PropTypes.bool.isRequired
};
