import React from 'react';
import PropTypes from 'prop-types';

import metrics from '../../../metrics';

import {Link} from '@components/Link';

const sendMetrics = () => metrics.send(['Выход из текущей сессии']);

export default function Logout({logoutURL}) {
    return (
        <div data-t='pssp:logout'>
            <div onClick={sendMetrics} className='s-block__logout s-block__sub_hl'>
                <Link href={logoutURL}>{i18n('Profile.logout.link')}</Link>
            </div>
        </div>
    );
}

Logout.propTypes = {
    logoutURL: PropTypes.string.isRequired
};
