import React from 'react';
import PropTypes from 'prop-types';

import {Tile} from './tile/tile.jsx';
import {BankCards} from './bank_cards';
import MailsBlock from './mails_block/mails_block.jsx';
import PersonalInfo from './personal_info/personal_info.jsx';
import AddressesBlock from './addresses_block/addresses_block.jsx';
import OtherSettingsBlock from './other_settings_block/other_settings_block.jsx';
import SubscriptionsBlock from './subscriptions/subscriptions';

export default function MordaLite({
    person,
    common,
    bnpl,
    emails,
    phones,
    access,
    security,
    settings,
    dispatch,
    addresses,
    changeAvatar,
    visibleBlocks,
    getTileClassName,
    mordaSubscriptionCards
}) {
    return (
        <>
            <Tile>
                <PersonalInfo
                    bnpl={bnpl}
                    person={person}
                    common={common}
                    settings={settings}
                    dispatch={dispatch}
                    changeAvatar={changeAvatar}
                    securityLevel={security.securityLevel}
                    hasPhone={Boolean(phones && phones.restore.length)}
                    is2faEnabled={access.is2faEnabled}
                    isSms2faEnabled={access.isSms2faEnabled}
                    isClosedPhoneAlert={security.isClosedPhoneAlert}
                    isClosed2faAlert={security.isClosed2faAlert}
                />
            </Tile>
            {visibleBlocks.MailsBlock && (
                <Tile className={getTileClassName('mail')}>
                    <MailsBlock
                        isLite={true}
                        person={person}
                        phones={phones}
                        emails={emails}
                        edit={common.edit}
                        tld={settings.tld}
                        dispatch={dispatch}
                        isPhone={settings.isPhone}
                        isTouch={settings.isTouch}
                        retpath={common.retpath || ''}
                        isSocialchik={person.isSocialchik}
                    />
                </Tile>
            )}
            {visibleBlocks.Subscriptions && (
                <SubscriptionsBlock
                    dispatch={dispatch}
                    subscriptionCards={mordaSubscriptionCards}
                    settings={settings}
                    common={common}
                />
            )}
            {visibleBlocks.BankCards && (
                <Tile className={getTileClassName('card')}>
                    <BankCards dispatch={dispatch} />
                </Tile>
            )}
            {visibleBlocks.AddressesBlock && (
                <Tile className={getTileClassName('maps')}>
                    <AddressesBlock common={common} settings={settings} dispatch={dispatch} addresses={addresses} />
                </Tile>
            )}
            {visibleBlocks.OtherSettingsBlock && (
                <Tile>
                    <OtherSettingsBlock common={common} settings={settings} dispatch={dispatch} />
                </Tile>
            )}
        </>
    );
}

MordaLite.propTypes = {
    access: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    getTileClassName: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    emails: PropTypes.object.isRequired,
    bnpl: PropTypes.object.isRequired,
    phones: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    billing: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    security: PropTypes.object.isRequired,
    addresses: PropTypes.object.isRequired,
    changeAvatar: PropTypes.object.isRequired,
    visibleBlocks: PropTypes.shape({
        BankCards: PropTypes.bool.isRequired,
        MailsBlock: PropTypes.bool.isRequired,
        AddressesBlock: PropTypes.bool.isRequired,
        OtherSettingsBlock: PropTypes.bool.isRequired,
        Subscriptions: PropTypes.bool.isRequired
    }).isRequired,
    mordaSubscriptionCards: PropTypes.object.isRequired
};
