import React from 'react';
import PropTypes from 'prop-types';

import {Logout} from '@blocks/morda/components/logout/logout.jsx';
import {GlobalLogout} from '@blocks/morda/components/global_logout/global_logout.jsx';

export default function PLogout({edit, dispatch, yandexuid}) {
    return (
        <div className='p-logout'>
            <div className='s-block s-block__margin'>
                <div className='s-block__sub s-block__sub_hl'>
                    <GlobalLogout yandexuid={yandexuid} dispatch={dispatch} setEditMode={edit} />
                </div>
            </div>
            <div className='s-block s-block__margin'>
                <div className='s-block__sub s-block__sub_hl'>
                    <Logout yandexuid={yandexuid} />
                </div>
            </div>
        </div>
    );
}

PLogout.propTypes = {
    dispatch: PropTypes.func.isRequired,
    edit: PropTypes.string,
    yandexuid: PropTypes.string.isRequired
};
