import {deepEqual} from '../../../utils';

/* eslint-disable no-invalid-this */

export function processEmails(items) {
    const emails = {
        forRestore: [],
        forRestoreConfirmed: [],
        forRestoreUnconfirmed: [],
        forNotifications: [],
        rpop: [],
        other: [],
        native: [],
        hasEmails: false,
        hasNoNative: false
    };

    Object.keys(items).forEach((emailName) => {
        const email = Object.assign({}, items[emailName]);

        email.name = emailName;
        switch (email.category) {
            case 'for_restore': {
                if (email.confirmed) {
                    emails.forRestoreConfirmed.push(email);
                } else {
                    emails.forRestoreUnconfirmed.push(email);
                }
                emails.forRestore.push(email);
                emails.hasEmails = true;
                emails.hasNoNative = true;
                break;
            }
            case 'for_notifications':
                emails.forNotifications.push(email);
                emails.hasEmails = true;
                emails.hasNoNative = true;
                break;
            case 'rpop':
            case 'other':
            case 'native':
                emails[email.category].push(email);
                emails.hasEmails = true;

                if (email.category !== 'native') {
                    emails.hasNoNative = true;
                }

                break;
            default:
                emails.other.push(email);
                emails.hasNoNative = true;
        }
    });

    Object.keys(emails).forEach((category) => {
        if (emails[category].length > 1) {
            emails[category] = emails[category].sort((a, b) => a.name < b.name);
        }
    });

    emails.native.sort((a, b) => Number(b.default) - Number(a.default));
    emails.forRestore.sort((a, b) => Number(b.confirmed) - Number(a.confirmed));
    emails.forNotifications.sort((a, b) => Number(b.confirmed) - Number(a.confirmed));

    return emails;
}

export function setProcessedEmails(nextProps) {
    if (!deepEqual(this.props.emails, nextProps.emails)) {
        this.emails = processEmails(nextProps.emails.emails || {});
    }
}

export function construct(props) {
    this.emails = processEmails(props.emails.emails || {});
}
