import React from 'react';
import PropTypes from 'prop-types';
import {Section} from '@blocks/morda/new/section/section.jsx';
import Toggle from '@blocks/morda/new/toggle/toggle.jsx';
import MailsRestore from './mails_restore.jsx';
import Phones from './phones.jsx';
import * as extracted from './mails_block.js';
import {hasExp} from '@blocks/selectors';

export default class MailsBlock extends React.PureComponent {
    constructor(props) {
        super(props);

        extracted.construct.call(this, props);
    }

    componentWillReceiveProps(nextProps) {
        extracted.setProcessedEmails.call(this, nextProps);
    }

    render() {
        const {
            dispatch,
            isSocialchik,
            isPhone,
            isTouch,
            emails,
            tld,
            isLite,
            phones,
            person = {},
            common = {},
            isNeoPhonish
        } = this.props;
        const isShowPhonesForNonpasswordExp = hasExp(this.props, 'show-phones-for-nonpassword-on');
        const {edit, retpath = ''} = common;
        const emailsStates = emails.states || [];
        const emailsState = emailsStates[emailsStates.length - 1];
        const count = this.emails.native.length - 2;
        const toggleText = i18n(
            {
                count,
                one: 'Profile.addresses.more.one',
                some: 'Profile.addresses.more.some',
                many: 'Profile.addresses.more.many',
                none: ''
            },
            count
        );

        return (
            <Section
                className='p-mails'
                icon='mail'
                title={i18n('Profile2.titles.mails_phones')}
                isHiddenDefault={true}
            >
                {this.emails.native.length > 0 && (
                    <div className='s-block s-block__margin'>
                        <Toggle
                            dt='section:native'
                            cls='ms-native'
                            margin={5}
                            itemKey='name'
                            itemClassName='s-block__sub s-block__sub_hl first-letter_red p-mails__item'
                            title={i18n('Profile2.native_mails')}
                            items={this.emails.native}
                            toggleText={toggleText}
                        />
                    </div>
                )}
                <div className='s-block s-block__margin'>
                    <MailsRestore
                        isLite={isLite}
                        emails={this.emails}
                        dispatch={dispatch}
                        isPhone={isPhone}
                        isTouch={isTouch}
                        edit={edit}
                        tld={tld}
                        retpath={retpath}
                        error={emails.error}
                        selectedEmail={emails.selectedEmail}
                        deleteRequestEmail={emails.deleteRequestEmail}
                        openAliasesList={emails.openAliasesList}
                        addedEmail={emails.addedEmail}
                        emailsState={emailsState}
                        loading={emails.loading}
                        person={person}
                    />
                </div>
                <div className='s-block'>
                    <Phones
                        isLite={isLite}
                        phones={phones}
                        isSocialchik={isSocialchik}
                        dispatch={dispatch}
                        isShowPhonesForNonpasswordExp={isShowPhonesForNonpasswordExp}
                        isNeoPhonish={isNeoPhonish}
                    />
                </div>
            </Section>
        );
    }
}

MailsBlock.propTypes = {
    isLite: PropTypes.bool,
    emails: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    isSocialchik: PropTypes.bool,
    isNeoPhonish: PropTypes.bool,
    isPhone: PropTypes.bool,
    isTouch: PropTypes.bool,
    common: PropTypes.shape({
        edit: PropTypes.string,
        retpath: PropTypes.string
    }),
    tld: PropTypes.string.isRequired,
    phones: PropTypes.object.isRequired,
    person: PropTypes.object
};
