import {push} from 'react-router-redux';

import {setEditMode} from '../../../common/actions';
import {changeEmailsState, EMAILS_GOAL_PREFIX, EMAILS_URLS} from '../../emails/actions';

import metrics from '../../../metrics';

/* eslint-disable no-invalid-this */

export const ADD_STATE = 'add-initial';
export const LIST_STATE = 'list-initial';

export function showModal(state, e) {
    const {dispatch, isTouch} = this.props;

    e.preventDefault();

    if (state === ADD_STATE) {
        metrics.goal(`${EMAILS_GOAL_PREFIX}_add_open`);
    } else {
        metrics.goal(`${EMAILS_GOAL_PREFIX}_list_open`);
    }

    dispatch(changeEmailsState(state));
    if (isTouch) {
        dispatch(push(EMAILS_URLS[state]));
    } else {
        dispatch(setEditMode('emails'));
    }
}
