import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Link} from '@components/Link';
import Modal from '@components/Wrappers/Modal.jsx';

import Toggle from '@blocks/morda/new/toggle/toggle.jsx';
import EmailsList from '@blocks/morda/emails/emails_list/emails_list.jsx';
import AddEmail from '@blocks/morda/emails/add_email/add_email.jsx';

import withMethods from '@blocks/hocs/withMethods';

import {EMAILS_URLS, EMAILS_STATES, setError, toggleAliasesList} from '@blocks/morda/emails/actions';

import metrics from '@blocks/metrics';

import * as extracted from './mails_restore.js';
import {setEditMode} from '@blocks/common/actions';

const ADDRESSES = 'Привязанные адреса';

export class MailsRestore extends React.PureComponent {
    constructor(props) {
        super(props);

        this.showEmailsList = extracted.showModal.bind(this, extracted.LIST_STATE);
        this.showAddEmail = extracted.showModal.bind(this, extracted.ADD_STATE);
    }

    closeModal = () => {
        const {dispatch, openAliasesList} = this.props;

        this.setState({email: ''});
        dispatch(setError(null));
        dispatch(setEditMode(null));

        if (openAliasesList) {
            dispatch(toggleAliasesList());
        }
    };

    render() {
        const {
            emails,
            dispatch,
            isPhone,
            isTouch,
            methods,
            edit,
            tld,
            retpath,
            error,
            selectedEmail,
            deleteRequestEmail,
            openAliasesList,
            addedEmail,
            emailsState,
            isLite,
            loading,
            person = {}
        } = this.props;
        const {havePassword} = person;
        const forRestoreCount = emails.forRestore.length - 2;
        const forRestoreToggleText = i18n(
            {
                count: forRestoreCount,
                one: 'Profile.addresses.more.one',
                some: 'Profile.addresses.more.some',
                many: 'Profile.addresses.more.many',
                none: ''
            },
            forRestoreCount
        );
        const forNotificationsCount = emails.forNotifications.length - 2;
        const forNotificationsToggleText = i18n(
            {
                count: forNotificationsCount,
                one: 'Profile.addresses.more.one',
                some: 'Profile.addresses.more.some',
                many: 'Profile.addresses.more.many',
                none: ''
            },
            forNotificationsCount
        );
        const rpopCount = emails.rpop.length - 2;
        const rpopToggleText = i18n(
            {
                count: rpopCount,
                one: 'Profile.addresses.more.one',
                some: 'Profile.addresses.more.some',
                many: 'Profile.addresses.more.many',
                none: ''
            },
            rpopCount
        );
        const otherCount = emails.other.length - 2;
        const otherToggleText = i18n(
            {
                count: otherCount,
                one: 'Profile.addresses.more.one',
                some: 'Profile.addresses.more.some',
                many: 'Profile.addresses.more.many',
                none: ''
            },
            otherCount
        );

        return (
            <div data-t='pssp:mails-restore'>
                {!emails.hasNoNative && (
                    <div data-t='pssp:mails-restore_empty'>
                        <div className='s-block__sub s-block__sub_hl'>
                            <span data-t='pssp:mails-restore_add' onClick={methods.addEmail}>
                                <Link onClick={this.showAddEmail} href={EMAILS_URLS[extracted.ADD_STATE]}>
                                    {!havePassword
                                        ? i18n('Profile2.mail.for_notify.add')
                                        : i18n('Profile2.mail.for_restore.add')}
                                </Link>
                            </span>
                        </div>
                        <div className='s-block__sub'>
                            {havePassword
                                ? i18n('Profile2.mail.for_restore.sub')
                                : i18n('Profile2.mail.for_notify.sub')}
                        </div>
                    </div>
                )}
                {emails.forRestore.length > 0 && (
                    <div>
                        <Toggle
                            dt='section:restore'
                            cls='ms-restore'
                            toggleMax={5}
                            openList={this.showEmailsList}
                            margin={5}
                            itemKey='name'
                            itemClassName='s-block__sub s-block__sub_hl'
                            title={i18n('Profile.emails.page.for-restore')}
                            items={emails.forRestore}
                            toggleText={forRestoreToggleText}
                        />
                        <div>
                            <span data-t='pssp:mails-restore_add' onClick={methods.addEmail}>
                                <Link onClick={this.showAddEmail} href={EMAILS_URLS[extracted.ADD_STATE]}>
                                    {i18n('Profile2.mail.for_restore.add')}
                                </Link>
                            </span>
                        </div>
                    </div>
                )}
                {emails.forNotifications.length > 0 && (
                    <div className={classnames({'s-block__mt': emails.forRestore.length})}>
                        <Toggle
                            dt='section:notifications'
                            cls='ms-notif'
                            toggleMax={5}
                            openList={this.showEmailsList}
                            margin={5}
                            itemKey='name'
                            itemClassName='s-block__sub s-block__sub_hl'
                            title={i18n('Profile.emails.page.for-notify')}
                            items={emails.forNotifications}
                            toggleText={forNotificationsToggleText}
                        />
                        <div>
                            <span data-t='pssp:mails-notify_add' onClick={methods.addEmail}>
                                <Link onClick={this.showAddEmail} href={EMAILS_URLS[extracted.ADD_STATE]}>
                                    {i18n('Profile.addresses.add')}
                                </Link>
                            </span>
                        </div>
                    </div>
                )}
                {emails.rpop.length > 0 && (
                    <div
                        className={classnames({
                            's-block__mt': emails.forRestore.length || emails.forNotifications.length
                        })}
                    >
                        <Toggle
                            dt='section:rpop'
                            cls='ms-rpop'
                            toggleMax={5}
                            openList={this.showEmailsList}
                            margin={5}
                            itemKey='name'
                            itemClassName='s-block__sub s-block__sub_hl'
                            title={i18n('Profile.emails.page.for-collect')}
                            items={emails.rpop}
                            toggleText={rpopToggleText}
                        />
                    </div>
                )}
                {emails.other.length > 0 && (
                    <div
                        className={classnames({
                            's-block__mt':
                                emails.forRestore.length || emails.forNotifications.length || emails.rpop.length
                        })}
                    >
                        <Toggle
                            dt='section:other'
                            cls='ms-other'
                            toggleMax={5}
                            openList={this.showEmailsList}
                            margin={5}
                            itemKey='name'
                            itemClassName='s-block__sub s-block__sub_hl'
                            title={i18n('Profile.emails.other')}
                            items={emails.other}
                            toggleText={otherToggleText}
                        />
                    </div>
                )}
                {emails.hasNoNative && (
                    <div>
                        <div className='s-block__mt'>
                            <span data-t='pssp:mails-show_list' onClick={methods.editEmail}>
                                <Link onClick={this.showEmailsList} href={EMAILS_URLS[extracted.LIST_STATE]}>
                                    {i18n('Profile2.show_list')}
                                </Link>
                            </span>
                        </div>
                    </div>
                )}
                {!isTouch && (
                    <Modal
                        visible={edit === 'emails'}
                        zIndexGroupLevel={-0.5}
                        onCloserClick={emailsState === EMAILS_STATES.list ? this.closeModal : undefined}
                        dataT='mails-restore'
                    >
                        {emailsState === EMAILS_STATES.list ? (
                            <EmailsList
                                isLite={isLite}
                                modal={true}
                                isMobile={isPhone}
                                error={error}
                                tld={tld}
                                selectedEmail={selectedEmail}
                                deleteRequestEmail={deleteRequestEmail}
                                addedEmail={addedEmail}
                                retpath={retpath}
                                emails={emails}
                                openAliasesList={openAliasesList}
                                haveEmails={emails.hasEmails}
                                loading={loading || false}
                                dispatch={dispatch}
                                person={person}
                            />
                        ) : (
                            <AddEmail
                                person={person}
                                dispatch={dispatch}
                                retpath={retpath}
                                isMobile={isPhone}
                                modal={true}
                                error={error}
                                loading={loading}
                                addedEmail={addedEmail}
                                addEmailState={emailsState}
                            />
                        )}
                    </Modal>
                )}
            </div>
        );
    }
}

MailsRestore.propTypes = {
    isLite: PropTypes.bool,
    emails: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    isPhone: PropTypes.bool,
    isTouch: PropTypes.bool,
    methods: PropTypes.object.isRequired,
    edit: PropTypes.string,
    tld: PropTypes.string.isRequired,
    retpath: PropTypes.string,
    error: PropTypes.string,
    selectedEmail: PropTypes.string,
    deleteRequestEmail: PropTypes.string,
    openAliasesList: PropTypes.bool.isRequired,
    addedEmail: PropTypes.string,
    emailsState: PropTypes.string,
    loading: PropTypes.string,
    person: PropTypes.object
};

export default withMethods(MailsRestore, metrics.send.bind(metrics), {
    addEmail: [ADDRESSES, 'Привязать дополнительный email'],
    editEmail: [ADDRESSES, 'Редактировать']
});
