import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Link} from '@components/Link';

import Toggle from '@blocks/morda/new/toggle/toggle.jsx';
import withMethods from '@blocks/hocs/withMethods';

import metrics from '@blocks/metrics';

const PHONES = 'Номера телефонов';

class Phones extends React.Component {
    shouldComponentUpdate() {
        return false;
    }

    render() {
        const {
            phones: {restore, other},
            methods,
            isSocialchik,
            isLite,
            isShowPhonesForNonpasswordExp,
            isNeoPhonish
        } = this.props;
        const PHONES_EDIT_PAGE = `/profile/phones?origin=passport_profile${isLite ? '&lite=1' : ''}`;
        const restoreCount = restore.length - 2;
        const othersCount = other.length - 2;
        const restoreToggleText = i18n(
            {
                count: restoreCount,
                one: 'Profile.phones.more.one',
                some: 'Profile.phones.more.some',
                many: 'Profile.phones.more.many',
                none: ''
            },
            restoreCount
        );
        const othersToggleText = i18n(
            {
                count: othersCount,
                one: 'Profile.phones.more.one',
                some: 'Profile.phones.more.some',
                many: 'Profile.phones.more.many',
                none: ''
            },
            othersCount
        );
        const isShowPhonesForNonpassword = isSocialchik && !isShowPhonesForNonpasswordExp && !isNeoPhonish;

        return (
            <div data-t='pssp:phones'>
                {((isShowPhonesForNonpassword && !other.length) ||
                    (!isShowPhonesForNonpassword && !restore.length)) && (
                    <div data-t='pssp:phones'>
                        <div className='s-block__sub s-block__sub_hl'>
                            <span data-t='pssp:phones-add' onClick={methods.addPhone}>
                                <Link href={PHONES_EDIT_PAGE} dataT='phones-edit'>
                                    {!isShowPhonesForNonpassword && other.length > 0
                                        ? i18n('Profile2.add.restore_phone_number')
                                        : i18n('Profile2.add.phone_number')}
                                </Link>
                            </span>
                        </div>
                        <div className='s-block__sub'>
                            {!isShowPhonesForNonpassword &&
                                ((isSocialchik && i18n('Profile2.phone_protect_sub_without_password')) ||
                                    i18n('Profile2.phone_protect_sub'))}
                        </div>
                    </div>
                )}
                {restore.length > 0 && (
                    <Toggle
                        dt='section:p-restore'
                        cls='ps-restore'
                        margin={5}
                        itemClassName='s-block__sub s-block__sub_hl'
                        title={restore.length > 1 ? i18n('Profile2.main_numbers') : i18n('Profile2.main_number')}
                        items={restore}
                        toggleText={restoreToggleText}
                        itemKey='number'
                    />
                )}
                {other.length > 0 && (
                    <div className={classnames({'s-block__mt': restore.length})}>
                        <Toggle
                            dt='section:other'
                            cls='ps-other'
                            margin={5}
                            itemClassName='s-block__sub s-block__sub_hl'
                            title={
                                other.length > 1
                                    ? i18n('Profile2.additional_numbers')
                                    : i18n('Profile2.additional_number')
                            }
                            items={other}
                            toggleText={othersToggleText}
                            itemKey='number'
                        />
                    </div>
                )}
                {(restore.length > 0 || other.length > 0) && (
                    <div className='s-block__mt'>
                        <span data-t='pssp:phones-add' onClick={methods.editPhone}>
                            <Link href={PHONES_EDIT_PAGE} dataT='phones-edit-sub-link'>
                                {i18n('Profile.common.edit')}
                            </Link>
                        </span>
                    </div>
                )}
            </div>
        );
    }
}

Phones.propTypes = {
    isLite: PropTypes.bool,
    phones: PropTypes.object.isRequired,
    isSocialchik: PropTypes.bool.isRequired,
    isShowPhonesForNonpasswordExp: PropTypes.bool,
    methods: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    isNeoPhonish: PropTypes.bool
};

export default withMethods(Phones, metrics.send.bind(metrics), {
    addPhone: [PHONES, 'Добавить'],
    editPhone: [PHONES, 'Редактировать']
});
