import React from 'react';
import PropTypes from 'prop-types';
import {AliceDeviceListItem} from '../AliceDeviceListItem';
import {cn} from '@bem-react/classname';
import './AliceDeviceList.styl';

const b = cn('AliceDeviceList');

export class AliceDeviceList extends React.Component {
    render() {
        const {devices = [], isApproved, revokeOnClick, approveOnClick, disapproveOnClick} = this.props;

        return (
            <div className={b()}>
                <div className={b('title')}>
                    {isApproved
                        ? i18n('Profile2.settings.alice.devices.approved.title')
                        : i18n('Profile2.settings.alice.devices.notApproved.title')}
                </div>
                <div className={b('list')}>
                    {devices.map((device) => (
                        <AliceDeviceListItem
                            device={device}
                            key={device.id}
                            isApproved={isApproved}
                            revokeOnClick={revokeOnClick}
                            approveOnClick={approveOnClick}
                            disapproveOnClick={disapproveOnClick}
                        />
                    ))}
                </div>
            </div>
        );
    }
}

AliceDeviceList.propTypes = {
    devices: PropTypes.arrayOf(PropTypes.object),
    isApproved: PropTypes.bool,
    revokeOnClick: PropTypes.func,
    approveOnClick: PropTypes.func,
    disapproveOnClick: PropTypes.func
};
