import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {cn} from '@bem-react/classname';
import './AliceDeviceListItem.styl';

const b = cn('AliceDeviceListItem');

const devicesTypes = {
    'smart-speaker-yandex-station': i18n('Profile2.settings.alice.devices.type.yandex-station'),
    'smart-speaker-yandex-station-2': i18n('Profile2.settings.alice.devices.type.yandex-station-2'),
    'smart-speaker-yandex-station-mini': i18n('Profile2.settings.alice.devices.type.yandex-station-mini'),
    'smart-speaker-prestigio-smartmate': i18n('Profile2.settings.alice.devices.type.prestigio-smartmate'),
    'smart-speaker-dexp-smartbox': i18n('Profile2.settings.alice.devices.type.dexp-smartbox'),
    'smart-speaker-jbl-link-portable': i18n('Profile2.settings.alice.devices.type.jbl-link-portable'),
    'smart-speaker-jet-smartmusic': i18n('Profile2.settings.alice.devices.type.jet-smartmusic'),
    'smart-speaker-digma-dihome': i18n('Profile2.settings.alice.devices.type.digma-dihome'),
    'smart-speaker-lg-xboom-wk7y': i18n('Profile2.settings.alice.devices.type.lg-xboom-wk7y'),
    'smart-speaker-irbis-a': i18n('Profile2.settings.alice.devices.type.irbis-a'),
    'smart-speaker-elari-smartbeat': i18n('Profile2.settings.alice.devices.type.elari-smartbeat'),
    'smart-speaker-jbl-link-music': i18n('Profile2.settings.alice.devices.type.jbl-link-music'),
    'smart_speaker-yandex-station-mini-2': i18n('Profile2.settings.alice.devices.type.yandex-station-mini'),
    'smart_speaker-yandex-station-mini-2-no-clock': i18n('Profile2.settings.alice.devices.type.yandex-station-mini'),
    unknown: i18n('Profile2.settings.alice.devices.type.unknow')
};

export class AliceDeviceListItem extends React.Component {
    revokeDevice = () => {
        const {device, revokeOnClick} = this.props;

        revokeOnClick(device);
    };
    approveDevice = () => {
        const {device, approveOnClick} = this.props;

        approveOnClick(device);
    };
    disapproveDevice = () => {
        const {device, disapproveOnClick} = this.props;

        disapproveOnClick(device);
    };
    render() {
        const {device, isApproved} = this.props;
        const type = device.type.replace(/devices[.]types[.]/g, '').replace(/[._]/g, '-');
        const typeText = devicesTypes[type] || devicesTypes.unknown;
        const iconUrl = (device.icon_url && `${device.icon_url}/40x40`) || '';

        return (
            <div className={b()}>
                <div className={b('info')}>
                    <div className={b('icon', {type})} style={{backgroundImage: `url(${iconUrl})`}} />
                    <div className={b('infoBlock')}>
                        <div className={b('name')}>{device.name}</div>
                        <div className={b('type')}>{typeText}</div>
                    </div>
                </div>
                <div className={b('buttons')}>
                    {isApproved ? (
                        <span className={b('button')}>
                            <Button
                                text={i18n('Profile2.settings.alice.operations.revoke')}
                                onClick={this.revokeDevice}
                                view='pseudo'
                                size='l'
                            />
                        </span>
                    ) : (
                        <>
                            {device.current && (
                                <span className={b('button')}>
                                    <Button
                                        text={i18n('Profile2.settings.alice.operations.disapprove')}
                                        onClick={this.disapproveDevice}
                                        view='pseudo'
                                        size='l'
                                    />
                                </span>
                            )}
                            <span className={b('button')}>
                                <Button
                                    text={
                                        device.current
                                            ? i18n('Profile2.settings.alice.operations.approve.current')
                                            : i18n('Profile2.settings.alice.operations.approve')
                                    }
                                    onClick={this.approveDevice}
                                    size='l'
                                />
                            </span>
                        </>
                    )}
                </div>
            </div>
        );
    }
}

AliceDeviceListItem.propTypes = {
    device: PropTypes.shape({
        type: PropTypes.string,
        icon_url: PropTypes.string,
        name: PropTypes.string,
        lastActivity: PropTypes.string,
        current: PropTypes.bool
    }).isRequired,
    isApproved: PropTypes.bool,
    revokeOnClick: PropTypes.func,
    approveOnClick: PropTypes.func,
    disapproveOnClick: PropTypes.func,
    language: PropTypes.string
};
