import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import './AliceRevokeModal.styl';

const b = cn('AliceRevokeModal');

export const AliceRevokeModal = ({onRevokeAccept, onRevokeDecline}) => (
    <div className={b()}>
        <div className={b('content')}>
            <div className={b('text')}>{i18n('Profile2.settings.alice.revoke.text')}</div>
            <div className={b('buttons')}>
                <span className={b('button')}>
                    <Button
                        text={i18n('Profile2.settings.alice.revoke.cancel')}
                        onClick={onRevokeDecline}
                        view='pseudo'
                        size='l'
                    />
                </span>
                <span className={b('button')}>
                    <Button text={i18n('Profile2.settings.alice.revoke.confirm')} onClick={onRevokeAccept} size='l' />
                </span>
            </div>
        </div>
    </div>
);

AliceRevokeModal.propTypes = {
    onRevokeAccept: PropTypes.func,
    onRevokeDecline: PropTypes.func,
    device: PropTypes.shape({
        name: PropTypes.string
    })
};
