export const SET_ALICE_HELPING_STATE = 'SET_ALICE_HELPING_STATE';
export const SET_ALICE_SETTINGS = 'SET_ALICE_SETTINGS';
export const SET_ALICE_LOADING = 'SET_ALICE_LOADING';
export const SET_ALICE_DEVICES = 'SET_ALICE_DEVICES';
export const REVOKE_DEVICE = 'REVOKE_DEVICE';
export const DISAPPROVE_DEVICE = 'DISAPPROVE_DEVICE';
export const APPROVE_DEVICE = 'APPROVE_DEVICE';

export const setAliceHelpingState = (state) => ({
    type: SET_ALICE_HELPING_STATE,
    payload: {state}
});

export const setAliceSettings = (settings) => ({
    type: SET_ALICE_SETTINGS,
    payload: {settings}
});

export const setAliceDevices = (devices) => ({
    type: SET_ALICE_DEVICES,
    payload: {devices}
});

export const setLoadingAlice = (isLoading) => ({
    type: SET_ALICE_LOADING,
    payload: {isLoading}
});

export const revokeDevice = (deviceId) => ({
    type: REVOKE_DEVICE,
    payload: {deviceId}
});

export const disapproveDevice = (deviceId) => ({
    type: DISAPPROVE_DEVICE,
    payload: {deviceId}
});

export const approveDevice = (deviceId) => ({
    type: APPROVE_DEVICE,
    payload: {deviceId}
});
