import {
    SET_ALICE_HELPING_STATE,
    SET_ALICE_LOADING,
    SET_ALICE_SETTINGS,
    SET_ALICE_DEVICES,
    REVOKE_DEVICE,
    DISAPPROVE_DEVICE,
    APPROVE_DEVICE
} from './actions';
import {getQueryParam} from '@blocks/utils';

const sortDevices = (deviceIds) => (device, other) => {
    if (deviceIds.includes(device.id)) {
        return -1;
    }
    if (deviceIds.includes(other.id)) {
        return 1;
    }
    return 0;
};

export const INITIAL_STATE = {
    isLoading: true,
    settings: {
        isHelpEnabled: null
    },
    devices: {
        approved: [],
        disapproved: []
    }
};

export default function alice(state = INITIAL_STATE, action = {}) {
    const {type, payload} = action;
    const queryDeviceIds = (getQueryParam('deviceId') || '').split(',');

    switch (type) {
        case SET_ALICE_HELPING_STATE:
            return Object.assign({}, state, {
                settings: {isHelpEnabled: payload.state}
            });
        case SET_ALICE_LOADING:
            return Object.assign({}, state, {isLoading: payload.isLoading});
        case SET_ALICE_SETTINGS:
            return Object.assign({}, state, {settings: payload.settings});
        case SET_ALICE_DEVICES: {
            const {
                devices: {approved, disapproved}
            } = payload;

            return Object.assign({}, state, {
                devices: {
                    approved,
                    disapproved: disapproved.sort(sortDevices(queryDeviceIds))
                }
            });
        }
        case REVOKE_DEVICE: {
            const {approved, disapproved} = state.devices;
            const disapprovedDevice = approved.find((device) => device.id === payload.deviceId);

            return disapprovedDevice
                ? Object.assign({}, state, {
                      devices: {
                          approved: approved.filter((device) => device.id !== payload.deviceId),
                          disapproved: [...disapproved, disapprovedDevice].sort(sortDevices(queryDeviceIds))
                      }
                  })
                : state;
        }
        case DISAPPROVE_DEVICE: {
            const {approved, disapproved} = state.devices;
            const {deviceId} = payload;

            return Object.assign({}, state, {
                devices: {
                    approved,
                    disapproved: disapproved
                        .map((device) => (device.id === deviceId ? {...device, current: false} : device))
                        .sort(sortDevices(queryDeviceIds))
                }
            });
        }
        case APPROVE_DEVICE: {
            const {approved, disapproved} = state.devices;
            const approvedDevice = disapproved.find((device) => device.id === payload.deviceId);

            return approvedDevice
                ? Object.assign({}, state, {
                      devices: {
                          approved: [...approved, approvedDevice],
                          disapproved: disapproved.filter((device) => device.id !== payload.deviceId)
                      }
                  })
                : state;
        }
        default:
            return state;
    }
}
