import React from 'react';
import PropTypes from 'prop-types';
import {push} from 'connected-react-router';

import {Link} from '@components/Link';

import Modal from '@components/Wrappers/Modal.jsx';
import AliceModal from './modal.jsx';
import {setEditMode} from '@blocks/common/actions';

export default class AliceBlock extends React.Component {
    showAlicePopup = () => {
        const {
            settings: {isTouch},
            dispatch,
            retpath
        } = this.props;

        if (isTouch) {
            let redirectUrl = '/profile/alice-settings';

            if (retpath) {
                redirectUrl += `?retpath=${encodeURIComponent(retpath)}`;
            }

            dispatch(push(redirectUrl));
            return;
        }
        dispatch(setEditMode('alice-settings'));
    };

    closeModal = () => {
        const {dispatch} = this.props;

        dispatch(setEditMode(null));
    };

    render() {
        const {dispatch, settings, edit, common} = this.props;

        const modalOpened = edit === 'alice-settings';

        return (
            <div data-t='pssp:alice-block'>
                <div className='s-block__sub s-block__sub_hl'>
                    <Link pseudo={true} onClick={this.showAlicePopup}>
                        {i18n('Profile2.settings.alice.popup_link')}
                    </Link>
                    {!settings.isTouch && (
                        <Modal
                            cls='alice-settings__modal'
                            visible={modalOpened}
                            onCloserClick={this.closeModal}
                            dataT='alice'
                        >
                            {modalOpened && (
                                <AliceModal
                                    modal={true}
                                    edit={edit}
                                    common={common}
                                    dispatch={dispatch}
                                    settings={settings}
                                />
                            )}
                        </Modal>
                    )}
                </div>
            </div>
        );
    }
}

AliceBlock.propTypes = {
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    edit: PropTypes.string,
    retpath: PropTypes.string.isRequired,
    settings: PropTypes.object.isRequired
};
