import {
    setAliceSettings,
    setLoadingAlice,
    setAliceDevices,
    setAliceHelpingState,
    revokeDevice,
    approveDevice
} from './actions/actions';
import api from '@blocks/api';
import {getQueryParam} from '@blocks/utils';

export const postHelping = (value) => (dispatch) => {
    dispatch(setAliceHelpingState(value));

    return api
        .request('alice.settings.setHelping', {value})
        .done(({status}) => {
            if (status !== 'ok') {
                dispatch(setAliceHelpingState(!value));
            }
        })
        .fail(() => dispatch(setAliceHelpingState(!value)));
};

export const fetchSettings = () => (dispatch) => {
    const deviceId = getQueryParam('deviceId');

    dispatch(setLoadingAlice(true));

    return Promise.all([
        api.request('alice.settings').done((settings) => dispatch(setAliceSettings(settings))),
        api.request('alice.devices', {deviceId}).done((devices) => dispatch(setAliceDevices(devices)))
    ])
        .catch(() => {})
        .then(() => dispatch(setLoadingAlice(false)));
};

export const postRevokeDevice = (deviceId) => (dispatch) => {
    return api.request('alice.devices.revoke', {deviceId}).done(() => dispatch(revokeDevice(deviceId)));
};

export const postApproveDevice = (deviceId) => (dispatch) => {
    return api.request('alice.devices.approve', {deviceId}).done(() => dispatch(approveDevice(deviceId)));
};
