import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {AliceSettings} from './AliceSettings';
import ReturnToService from '@blocks/morda/components/return_button/return_button.jsx';

class AliceModal extends Component {
    render() {
        const {dispatch, common, settings, modal} = this.props;

        const ua = settings.ua;
        const isPhone = ua.isMobile || (ua.isTouch && !ua.isTablet);

        return (
            <div
                className={classnames({
                    'p-control-form': true
                })}
            >
                <h2 className='section-title alice-settings-modal__title'>
                    <div className='other-settings-icon other-settings-icon_alice' />
                    {i18n('Profile2.settings.alice')}
                </h2>

                <AliceSettings
                    modal={modal}
                    settings={settings}
                    edit={common.edit}
                    retpath={common.retpath || ''}
                    dispatch={dispatch}
                    common={common}
                />

                <ReturnToService
                    className='social-modal__return-button'
                    retpath={common.retpath}
                    isModal={modal}
                    isMobile={isPhone}
                />
            </div>
        );
    }
}

AliceModal.propTypes = {
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    modal: PropTypes.bool
};

export default AliceModal;
