import React from 'react';
import PropTypes from 'prop-types';

import {withRouter} from 'react-router';
import {Section} from '@blocks/morda/new/section/section.jsx';
import AliceBlock from './alice/alice.jsx';
import {SubsModal} from '@blocks/Subs/SubsModal.jsx';
import {hasExp} from '@blocks/selectors';
import {Link} from '@components/Link';
import metrics from '@blocks/metrics';
import classnames from 'classnames';

class OtherSettingsBlock extends React.Component {
    static sendDeleteMetrics() {
        metrics.send('Другие настройки: Удалить аккаунт');
    }

    render() {
        const {dispatch, common, settings, location = {}} = this.props;
        const {isSupportCenterEnable} = common;
        const isSupportPage = isSupportCenterEnable && location.pathname.match(/^\/support/);

        return (
            <Section
                className='p-other-settings'
                icon='other-settings'
                title={i18n('Profile2.titles.other_settings')}
                isHiddenDefault={true}
            >
                {settings.tld === 'ru' && (
                    <div className='s-block s-block__margin'>
                        <AliceBlock
                            common={common}
                            edit={common.edit}
                            retpath={common.retpath || ''}
                            settings={settings}
                            dispatch={dispatch}
                        />
                    </div>
                )}
                {settings.language === 'ru' &&
                    settings.tld === 'ru' &&
                    hasExp({common}, 'passport-subs-eula-check-on') && (
                        <div className='s-block s-block__margin'>
                            <SubsModal isModal={true} dispatch={dispatch} />
                        </div>
                    )}
                {hasExp({common}, 'passport-gdpr-enabled') && (
                    <div className='s-block s-block__margin s-block__margin_last-m'>
                        <div data-t='pssp:gdpr-block'>
                            <div className='s-block__sub s-block__sub_hl'>
                                <Link href={`/profile/data${location.search || ''}`}>
                                    {i18n('DeleteData.data-managment')}
                                </Link>
                            </div>
                        </div>
                    </div>
                )}
                {hasExp({common}, 'layout-footer-delete-account') && (
                    <div className='s-block'>
                        <div>
                            <div
                                className={classnames('s-block__sub', {
                                    's-block__sub_hl': !common.isPDD
                                })}
                            >
                                {!common.isPDD && !isSupportPage && (
                                    <span onClick={OtherSettingsBlock.sendDeleteMetrics}>
                                        <Link
                                            href={
                                                hasExp({common}, 'delete_exp')
                                                    ? '/profile/delete?origin=passport_profile'
                                                    : '/passport?mode=delete&origin=passport_profile'
                                            }
                                        >
                                            {i18n('Profile.personal.hangover.remove')}
                                        </Link>
                                    </span>
                                )}
                                {common.isPDD && (
                                    <span className='s-block__desc'>
                                        {i18n('Profile.personal.hangover.remove.pdd')}
                                    </span>
                                )}
                            </div>
                        </div>
                    </div>
                )}
            </Section>
        );
    }
}

OtherSettingsBlock.propTypes = {
    location: PropTypes.object,
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired
};

export default withRouter(OtherSettingsBlock);
