import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Link} from '@components/Link';

import DisplayNameEditForm from '@blocks/morda/personal_info/display_name_edit_form.jsx';

import utils from '@blocks/utils';

import {showPersonalInfoEditForm, showDisplayNameEditForm, showPublicIdEditForm} from '../personal_info.js';

import {cn} from '@bem-react/classname';
import './AdditionalPersonalInfo.styl';
import {VerifiedMark} from '@components/VerifiedMark';

const b = cn('AdditionalPersonalInfo');

export class AdditionalPersonalInfo extends React.Component {
    showPersonalInfoEditForm = (e) => showPersonalInfoEditForm.call(this, e);
    showDisplayNameEditForm = (e) => showDisplayNameEditForm.call(this, e);
    showPublicIdEditForm = (e) => showPublicIdEditForm.call(this, e);
    renderBirthday = () => {
        const {isWSUser, birthday, methods, language, passportLinks} = this.props;
        const dateParts = utils.dateToText(birthday, {year: true}).split(' ');

        return (
            <div className={b('birthday')}>
                {birthday ? (
                    <div>
                        <div data-t='profile-info:day_month'>
                            {dateParts[0]} {(dateParts[1] || '').toLowerCase()}
                        </div>
                        <div data-t='profile-info:year'>
                            {dateParts[2]} {language === 'ru' && i18n('Profile2.profile.year')}
                        </div>
                    </div>
                ) : !isWSUser ? (
                    <span onClick={methods.birthday}>
                        <Link href={passportLinks.personalInfo} onClick={this.showPersonalInfoEditForm}>
                            {i18n('Profile2.set_birthday')}
                        </Link>
                    </span>
                ) : null}
            </div>
        );
    };
    renderGeo = () => {
        const {isWSUser, city, countryName, methods, passportLinks} = this.props;
        const hasCountryOrCity = Boolean(countryName || city);

        return (
            <div className={b('geo')}>
                {hasCountryOrCity ? (
                    <div>
                        {countryName && (
                            <div data-t='profile-info:country' className='personal-info__geo-data'>
                                {countryName}
                                {city ? ',' : ''}
                            </div>
                        )}
                        {city && (
                            <div data-t='profile-info:city' className='personal-info__geo-data'>
                                {city}
                            </div>
                        )}
                    </div>
                ) : !isWSUser ? (
                    <div>
                        <span onClick={methods.birthday}>
                            <Link href={passportLinks.personalInfo} onClick={this.showPersonalInfoEditForm}>
                                {i18n('Profile2.set_geo')}
                            </Link>
                        </span>
                    </div>
                ) : null}
            </div>
        );
    };
    renderName = () => {
        const {
            isPhone,
            isTouch,
            publicDisplayName,
            passportLinks,
            isVerifiedAccount,
            isPublicAllowCheckboxExp
        } = this.props;
        const name = DisplayNameEditForm.getSplittedDisplayName(publicDisplayName);

        if (isPublicAllowCheckboxExp) {
            return (
                <div className={b('name')}>
                    <span>{i18n('Profile2.profile.display_name')}: </span>
                    <div
                        className={classnames('font-weight_bold', {
                            'personal-info__displayname_mobile': isPhone && !isVerifiedAccount
                        })}
                    >
                        <span className='dname-edit_color_red'>{name.head}</span>
                        <span>{name.tail}</span>
                        {isVerifiedAccount && <VerifiedMark />}
                    </div>
                    {!isVerifiedAccount && (
                        <div>
                            <Link href={passportLinks.profilePublic}>{i18n('_AUTH_.change')}</Link>
                        </div>
                    )}
                </div>
            );
        }

        return (
            <div className={b('name')}>
                <span>{i18n('Profile2.profile.display_name')}: </span>
                <span
                    className={classnames('personal-info__displayname font-weight_bold', {
                        'personal-info__displayname_mobile': isPhone && !isVerifiedAccount
                    })}
                >
                    <span className='dname-edit_color_red'>{name.head}</span>
                    <span>{name.tail}</span>
                    {isVerifiedAccount && <VerifiedMark />}
                    {!isTouch && !isVerifiedAccount && (
                        <a
                            href={passportLinks.displayName}
                            className={b('gear', ['p-icon', 'p-icon__gear'])}
                            onClick={this.showDisplayNameEditForm}
                            aria-label={i18n('Profile2.profile.gear-icon.aria-label')}
                        />
                    )}
                </span>
                {isTouch && !isVerifiedAccount && (
                    <span>
                        {' '}
                        <Link href={passportLinks.displayName} onClick={this.showDisplayNameEditForm}>
                            {i18n('_AUTH_.change')}
                        </Link>
                    </span>
                )}
            </div>
        );
    };
    renderChange = () => {
        const {isWSUser, methods, passportLinks, hasPublicProfile, isPublicAllowCheckboxExp} = this.props;

        return (
            <div className={b('change')}>
                {!isWSUser ? (
                    <>
                        <span onClick={methods.personalInfo}>
                            <Link href={passportLinks.personalInfo} onClick={this.showPersonalInfoEditForm}>
                                {i18n('Profile.personal.data.change')}
                            </Link>
                        </span>

                        {isPublicAllowCheckboxExp && !hasPublicProfile && (
                            <div className={b('tunePublicAccessLink')}>
                                <Link href={passportLinks.profilePublic}>{i18n('Profile2.publicAccess.tune')}</Link>
                            </div>
                        )}
                    </>
                ) : (
                    <span>{i18n('Profile.personal.data.change.pdd')}</span>
                )}
            </div>
        );
    };
    renderPublicId = () => {
        const {isTouch, publicId, passportLinks, isPublicAllowCheckboxExp, hasPublicProfile} = this.props;

        if (isPublicAllowCheckboxExp && !hasPublicProfile) {
            return null;
        }

        return (
            <div className={b('publicId')}>
                <span className={b('title')}>{i18n('Profile2.profile.publicId')}: </span>
                <span className={b('value', {unset: !publicId})}>
                    <span data-t='profile-info:public-id'>
                        {publicId ? `../${publicId}` : i18n('Profile2.profile.publicId.unset')}
                    </span>
                    {isTouch ? (
                        <span className={b('link')}>
                            {' '}
                            <Link href={passportLinks.publicId} onClick={this.showPublicIdEditForm}>
                                {i18n('_AUTH_.change')}
                            </Link>
                        </span>
                    ) : (
                        <a
                            href={passportLinks.publicId}
                            onClick={this.showPublicIdEditForm}
                            className={b('gear', ['p-icon', 'p-icon__gear'])}
                            aria-label={i18n('Profile2.profile.gear-icon.aria-label')}
                        />
                    )}
                </span>
            </div>
        );
    };
    render() {
        const {expLayout} = this.props;

        return (
            <div className={b({expLayout})}>
                <div className={b('block')}>
                    {this.renderBirthday()}
                    {this.renderGeo()}
                    {this.renderChange()}
                </div>
                <div className={b('separator')} />
                <div className={b('block')}>
                    {this.renderName()}
                    {this.renderPublicId()}
                </div>
            </div>
        );
    }
}

AdditionalPersonalInfo.propTypes = {
    isPhone: PropTypes.bool,
    isTouch: PropTypes.bool,
    language: PropTypes.string,
    isWSUser: PropTypes.bool,
    birthday: PropTypes.string,
    city: PropTypes.string,
    countryName: PropTypes.string,
    publicDisplayName: PropTypes.string,
    methods: PropTypes.object,
    publicId: PropTypes.string,
    passportLinks: PropTypes.object,
    isVerifiedAccount: PropTypes.bool,
    hasPublicProfile: PropTypes.bool,
    isPublicAllowCheckboxExp: PropTypes.bool,
    expLayout: PropTypes.bool
};
