import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {AdditionalPersonalInfo as Component} from './AdditionalPersonalInfo.jsx';

const mapStateToProps = (state) => {
    const {
        common: {isWSUser},
        person: {birthday, city, countryName, publicDisplayName, isVerifiedAccount, hasPublicProfile},
        publicId: {id, hasPublicIdSet},
        settings: {passportLinks, isPhone, isTouch, language}
    } = state;

    return {
        isWSUser,
        birthday,
        city,
        countryName,
        isPublicAllowCheckboxExp: hasExp(state, 'personal_data_checkbox_on'),
        publicId: hasPublicIdSet && id,
        passportLinks,
        publicDisplayName,
        isVerifiedAccount,
        isPhone,
        isTouch,
        language,
        hasPublicProfile
    };
};

export const AdditionalPersonalInfo = connect(mapStateToProps)(Component);
