import React, {useCallback} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import {Button} from '@components/Button';
import {Link} from '@components/Link';

import './FamilyAlert.styl';

const b = cn('FamilyAlert');

export const FamilyAlert = ({type, title, action, cardLink = false, onClick, onClose}) => {
    const handleClick = useCallback(
        (event) => {
            onClick && onClick(event);
        },
        [onClick]
    );

    const handleClose = useCallback(
        (event) => {
            event.preventDefault();
            onClose && onClose(event);
        },
        [onClose]
    );

    const Component = cardLink ? Link : 'div';

    return (
        <Component
            className={b({
                clickable: Boolean(cardLink || onClick),
                hasClose: Boolean(onClose)
            })}
            href={typeof cardLink === 'string' ? cardLink : null}
            onClick={handleClick}
        >
            <div className={b('leftIcon')}>{type && <span className={b(type)} />}</div>
            <div className={b('content')}>
                <div className={b('title')}>{title}</div>
                <div className={b('action')}>{action}</div>
            </div>
            {onClose && (
                <Button className={b('closeIcon')} view='clear' size='m' onClick={handleClose}>
                    <span className={b('close')} />
                </Button>
            )}
        </Component>
    );
};

FamilyAlert.propTypes = {
    type: PropTypes.oneOf(['plus', 'pay']),
    title: PropTypes.string,
    action: PropTypes.string,
    cardLink: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    onClick: PropTypes.func,
    onClose: PropTypes.func
};
