import React, {useState, useEffect, useCallback, useMemo} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import {FamilyAlert} from '../FamilyAlert/index';
import {setCookie} from '@blocks/utils';
import {metrics} from '../utils/metrics';
import {hasExp} from '@blocks/selectors';

import './FamilyAlertSwitch.styl';

const b = cn('FamilyAlertSwitch');

export const FamilyAlertSwitch = ({
    common,
    hasFamilyInStore,
    fetchFamily,
    familyCapacity,
    slotsCountByGroup = {
        member: 0
    },
    hasFamilySubscription,
    isAdminAccess,
    hasFamily,
    // hasMembers,
    cardInfo = {},
    isAbleToUsePay,
    isClosedProfileAlertPlus,
    isClosedProfileAlertPay,
    plusLink
}) => {
    const [showPlusAlert, setShowPlusAlert] = useState(hasFamilyInStore && isAdminAccess && !isClosedProfileAlertPlus);
    const [showPayAlert, setShowPayAlert] = useState(hasFamilyInStore && isAdminAccess && !isClosedProfileAlertPay);

    useEffect(() => {
        !hasFamilyInStore && fetchFamily();
    }, []);

    const onClickPlusAlert = useCallback(() => {
        metrics.sendPlus(['Нажали']);
    }, []);
    const onClosePlusAlert = useCallback(() => {
        metrics.sendPlus(['Закрытие']);
        setCookie('profile_alert_plus', 14);
        setShowPlusAlert(false);
    }, []);

    const onClickPayAlert = useCallback(() => {
        metrics.sendPay(['Нажали']);
    }, []);
    const onClosePayAlert = useCallback(() => {
        metrics.sendPay(['Закрытие']);
        setCookie('profile_alert_pay', 14);
        setShowPayAlert(false);
    }, []);

    // по дизайну familyCapacity === 4
    const familyMembersLength = hasFamily ? slotsCountByGroup.member : 1;
    const familySlotsLeft = familyCapacity - familyMembersLength;
    const notFullFamily = hasFamily && 1 < familyMembersLength && familyMembersLength < familyCapacity;
    const fullFamily = hasFamily && familyMembersLength === familyCapacity;
    const {cardId, bound} = cardInfo;
    const hasFamilyPay = Boolean(isAbleToUsePay && bound && cardId);

    // есть Мульти && (Семьи нет || Семья <4)
    const noFamilyOrSmallFamilyAndHasMulti = hasFamilySubscription && (!hasFamily || notFullFamily) && isAdminAccess;

    // есть Мульти && Cемья полная, админ
    const familyAndHasMulti = hasFamilySubscription && fullFamily && isAdminAccess;

    // нет Мульти && нет карты && (Cемья (не) полная)
    const familyAndNoMultiNoPay =
        !hasFamilySubscription && !hasFamilyPay && (notFullFamily || fullFamily) && isAdminAccess;

    // нет Мульти && есть карта && Cемья полная
    const familyAndNoMultiHasPay =
        !hasFamilySubscription && hasFamilyPay && (notFullFamily || fullFamily) && isAdminAccess;

    const isShowPayAlert = familyAndHasMulti || !showPlusAlert;

    const hasAll = hasFamilySubscription && hasFamilyPay && fullFamily && isAdminAccess;

    const renderExpCase = useMemo(() => {
        if (noFamilyOrSmallFamilyAndHasMulti || familyAndNoMultiNoPay || familyAndNoMultiHasPay) {
            return true;
        }

        return hasExp({common}, 'profile-family-alert-first-case');
    }, [noFamilyOrSmallFamilyAndHasMulti, familyAndNoMultiNoPay, familyAndNoMultiHasPay]);
    const getPlusAlertTitle = useCallback(() => {
        if (noFamilyOrSmallFamilyAndHasMulti) {
            return (familySlotsLeft > 1
                ? i18n('Profile2.family.plus.title.noFamilyOrSmallFamilyAndHasMulti')
                : i18n('Profile2.family.plus.title.noFamilyOrSmallFamilyAndHasMulti.one')
            ).replace('{familySlotsLeft}', familySlotsLeft);
        }

        if (familyAndNoMultiNoPay) {
            return i18n('Profile2.family.plus.title.familyAndNoMultiNoPay');
        }

        if (familyAndNoMultiHasPay) {
            return i18n('Profile2.family.plus.title.familyAndNoMultiHasPay');
        }

        return i18n('Profile2.family.plus.title.noFamilyAndMulti');
    }, [noFamilyOrSmallFamilyAndHasMulti, familyAndNoMultiNoPay, familyAndNoMultiHasPay, familySlotsLeft]);
    const getPlusAlertAction = useCallback(() => {
        if (familyAndNoMultiNoPay) {
            return i18n('Profile2.family.plus.action.familyAndNoMultiNoPay');
        }

        if (familyAndNoMultiHasPay) {
            return i18n('Profile2.family.plus.action.familyAndNoMultiHasPay');
        }

        return i18n('Profile2.family.plus.action.noFamilyAndMulti');
    }, [familyAndNoMultiNoPay, familyAndNoMultiHasPay]);
    const getPlusAlertLink = useCallback(() => {
        if (noFamilyOrSmallFamilyAndHasMulti) {
            return './profile/family/invite';
        }

        if (familyAndNoMultiNoPay) {
            return './profile/family';
        }

        if (familyAndNoMultiHasPay) {
            return plusLink;
        }

        return './profile/family/invite';
    }, [noFamilyOrSmallFamilyAndHasMulti, familyAndNoMultiNoPay, familyAndNoMultiHasPay, plusLink]);

    useEffect(() => {
        if (hasFamilyInStore && !hasAll) {
            const locShowPlusAlert = isAdminAccess && !isClosedProfileAlertPlus;
            const locShowPayAlert = isAdminAccess && !isClosedProfileAlertPay;

            setShowPlusAlert(locShowPlusAlert);
            setShowPayAlert(locShowPayAlert);

            if (isShowPayAlert && locShowPayAlert) {
                metrics.sendPay(['Показали']);
            } else if (locShowPlusAlert) {
                metrics.sendPlus(['Показали']);
            }
        }
    }, [hasFamilyInStore, isAdminAccess]);

    if (hasAll) {
        return null;
    }

    return (
        <div className={b()}>
            {isShowPayAlert
                ? showPayAlert && (
                      <FamilyAlert
                          type={'pay'}
                          title={i18n('Profile2.family.pay.title')}
                          action={i18n('Profile2.family.pay.action')}
                          cardLink={'./profile/family/pay-cards'}
                          onClick={onClickPayAlert}
                          onClose={onClosePayAlert}
                      />
                  )
                : showPlusAlert &&
                  renderExpCase && (
                      <FamilyAlert
                          type={'plus'}
                          title={getPlusAlertTitle()}
                          action={getPlusAlertAction()}
                          cardLink={getPlusAlertLink()}
                          onClick={onClickPlusAlert}
                          onClose={onClosePlusAlert}
                      />
                  )}
        </div>
    );
};

FamilyAlertSwitch.propTypes = {
    common: PropTypes.object,
    hasFamilyInStore: PropTypes.bool,
    fetchFamily: PropTypes.func,
    familyCapacity: PropTypes.number,
    slotsCountByGroup: PropTypes.shape({
        color: PropTypes.string,
        fontSize: PropTypes.number
    }),
    hasFamilySubscription: PropTypes.bool,
    isAdminAccess: PropTypes.bool,
    hasFamily: PropTypes.bool,
    hasMembers: PropTypes.bool,
    cardInfo: PropTypes.object,
    isAbleToUsePay: PropTypes.bool,
    isClosedProfileAlertPlus: PropTypes.bool,
    isClosedProfileAlertPay: PropTypes.bool,
    plusLink: PropTypes.string
};
