import {connect} from 'react-redux';
import {fetchFamily} from '@blocks/morda/new/family/middlewares/api/state';
import {FamilyAlertSwitch as Component} from './FamilyAlertSwitch';
import passport from '@plibs/pclientjs/js/passport';

const mapStateToProps = (state) => {
    const {
        family: {
            familyId,
            memberSlots,
            familyCapacity,
            slotsCountByGroup,
            hasFamilySubscription,
            isAdminAccess,
            hasFamily,
            hasMembers,
            pay = null,
            yourSlot: {hasPlus = false} = {}
        } = {},
        phones: {restore = []} = {},
        common,
        settings: {plusHost}
    } = state;

    const {cardInfo = {}} = pay ?? {};
    const passportGetCookie = passport && passport.util && passport.util.getCookie;
    const isClosedProfileAlertPlus = Boolean(passportGetCookie && passport.util.getCookie('profile_alert_plus'));
    const isClosedProfileAlertPay = Boolean(passportGetCookie && passport.util.getCookie('profile_alert_pay'));
    /* eslint-disable max-len */
    const trialMultiPlusLink = `${plusHost}/my/promo-family-option?utm_source=yandexid&utm_medium=passport_menu&utm_campaign=yandexid_plus`;
    const multiPlusLink = `${plusHost}/family?utm_source=yandexid&utm_medium=passport_menu&utm_campaign=yandexid_no_plus`;
    const plusLink = hasPlus ? trialMultiPlusLink : multiPlusLink;

    return {
        common,
        hasFamilyInStore: Boolean(familyId) || Array.isArray(memberSlots),
        familyCapacity,
        slotsCountByGroup,
        hasFamilySubscription,
        isAdminAccess,
        hasFamily,
        hasMembers,
        cardInfo,
        isAbleToUsePay: Boolean(restore.length),
        isClosedProfileAlertPlus,
        isClosedProfileAlertPay,
        plusLink
    };
};

const mapDispatchToProps = {fetchFamily};

export const FamilyAlertSwitch = connect(mapStateToProps, mapDispatchToProps)(Component);
