import React, {useCallback} from 'react';
import {cn} from '@bem-react/classname';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import {Button} from '@components/Button';

import './SecurityAlert.styl';

const b = cn('SecurityAlert');

export const SecurityAlert = ({icon, title, action, href, hasClose, className, isTouch, onClose, onClick}) => {
    const closeIconProvider = useCallback((classname) => <div className={b('cross', [classname])} />, []);
    const onClickClose = useCallback(
        (event) => {
            event.preventDefault();
            onClose && onClose();
        },
        [onClose]
    );

    return (
        <Link
            className={b({hasClose, hasHover: !isTouch, unactive: !onClick && !href && !action}, [className])}
            onClick={onClick}
            href={href}
        >
            {icon && icon(b('icon'))}
            <div className={b('aside')}>
                <div className={b('title')}>{title}</div>
                <div className={b('action')}>{action}</div>
            </div>
            {hasClose && (
                <Button className={b('close')} view='clear' icon={closeIconProvider} size='m' onClick={onClickClose} />
            )}
        </Link>
    );
};

SecurityAlert.propTypes = {
    className: PropTypes.string,
    title: PropTypes.string.isRequired,
    action: PropTypes.string.isRequired,
    href: PropTypes.string,
    hasClose: PropTypes.bool,
    isTouch: PropTypes.bool,
    onClose: PropTypes.func,
    onClick: PropTypes.func,
    icon: PropTypes.func.isRequired
};
