import {push} from 'react-router-redux';

import {clearPersonalInfoFieldsErrors} from '../../personal_info/actions';
import {setEditMode} from '../../../common/actions';

import metrics from '../../../metrics';

/* eslint-disable no-invalid-this */

export const PERSONAL_INFO = '/profile/personal-info';
export const PUBLIC_ID = '/profile/publicid';
export const DISPLAY_NAME = '/profile/display-name';
export const METRICS_HEADER = 'Изменить персональные данные';

export function sendGoal() {
    metrics.goal(`profile_page_security_level_${this.props.securityLevel}`);
}

export function showDisplayNameEditForm(e) {
    const {isTouch, dispatch} = this.props;

    e.preventDefault();

    dispatch(isTouch ? push(DISPLAY_NAME) : setEditMode('display-name'));
}

export function showPersonalInfoEditForm(e) {
    const {isTouch, dispatch} = this.props;

    e.preventDefault();

    dispatch(isTouch ? push(PERSONAL_INFO) : setEditMode('personal-info'));
}

export function showPublicIdEditForm(e) {
    const {isTouch, dispatch} = this.props;

    e.preventDefault();

    metrics.send(['PublicId', 'Открытие попапа']);

    dispatch(isTouch ? push(PUBLIC_ID) : setEditMode('PUBLIC_ID'));
}

export function closePersonalInfoEditForm() {
    this.props.dispatch(clearPersonalInfoFieldsErrors());
    this.props.dispatch(setEditMode(''));
    metrics.send([METRICS_HEADER, 'Отменить']);
}
