import debounce from 'lodash/debounce';

import listen from '../../../common/event_listeners';
import metrics from '../../../metrics';

/* eslint-disable no-invalid-this */

export function construct(props) {
    this.sendMetrics =
        (props.metrics && props.metrics.length === 2 && sendMetrics.bind(null, props.metrics[0], props.metrics[1])) ||
        undefined;
    this.sizes = props.sizes.length > 1 ? props.sizes.sort((s1, s2) => s2.maxWidth - s1.maxWidth) : props.sizes;
}

export function sendMetrics(header, msg) {
    metrics.send([header, msg]);
}

export function onScroll(direction, scrolled) {
    if (scrolled === this.scrolled) {
        return;
    }

    const {items, fixed} = this.props;
    const {count, width} = this.cardsInfo;

    let diff = direction === 'left' ? -1 : 1;

    let scroll;

    if (!direction) {
        diff = 0;
    }

    this.scrolled =
        scrolled !== undefined ? scrolled : Math.max(0, Math.min(items.length - count, this.scrolled + count * diff));

    if (fixed) {
        scroll = Math.min(
            this.scrolled * width,
            Math.max(
                0,
                width * items.length -
                    (this.scrollRef && this.scrollRef.current ? this.scrollRef.current.clientWidth : 0)
            )
        );
    } else {
        scroll = width * this.scrolled;
    }

    this.setState({scroll});
}

export function listenForResize() {
    this.cardsInfo = getCardsInfo.call(this);

    if (!this.props.isTouch) {
        this.destroyListener = listen(
            'resize',
            debounce(() => {
                this.cardsInfo = getCardsInfo.call(this, true);

                this.scroll();
            }, 600)
        );
    }
}

export function updateAsyncIfNotFixed() {
    if (this.props.fixed) {
        this.timer = setTimeout(() => {
            this.forceUpdate();
        }, 0);
    }
}

export function getCardsInfo(update) {
    const {fixed, marginRight} = this.props;
    const windowWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    const sizes = this.sizes;

    let width;

    let count;

    for (let i = 0; i < sizes.length; i++) {
        if (windowWidth > sizes[i].maxWidth) {
            if (!fixed) {
                count = sizes[i].cardCount;
                width = 100 + marginRight;
            } else {
                count = Math.floor(
                    ((this.scrollRef && this.scrollRef.current ? this.scrollRef.current.clientWidth : 0) +
                        marginRight) /
                        (sizes[i].cardWidth + marginRight)
                );
                width = sizes[i].cardWidth + marginRight;
            }

            break;
        }
    }

    if (width === undefined || count === undefined) {
        const last = sizes[sizes.length - 1];

        width = last.cardWidth;
        count = last.cardCount;
    }

    if (update) {
        this.forceUpdate();
    }

    return {width, count};
}
