import React, {useState, useRef, useEffect} from 'react';
import {useSelector} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import SectionHead from '../section_head/section_head';

const b = cn('Section');

const ANIMATION_TIME_MS = 300;

export const Section = ({children, icon, title, isHiddenDefault = false, className}) => {
    const v2 = useSelector(({common = {}}) => common.v2 || false);
    const [isHidden, setIsHidden] = useState(isHiddenDefault);
    const [height, setHeight] = useState(isHiddenDefault ? '0' : '');
    const [isOverflowHidden, setOverflowHidden] = useState(isHiddenDefault);
    const contentRef = useRef(null);
    const isInProccesRef = useRef(false);
    const isFirstRenderRef = useRef(true);
    const timeoutRef = useRef(null);
    const onClick = () => {
        if (!isInProccesRef.current) {
            isInProccesRef.current = true;
            setIsHidden((v) => !v);
            setHeight(contentRef.current.scrollHeight);
        }
    };

    useEffect(() => {
        if (isFirstRenderRef.current) {
            isFirstRenderRef.current = false;
            return;
        }
        isHidden ? setHeight(0) : setOverflowHidden(false);
        clearTimeout(timeoutRef.current);
        timeoutRef.current = setTimeout(() => {
            isHidden ? setOverflowHidden(true) : setHeight('');
            isInProccesRef.current = false;
        }, ANIMATION_TIME_MS);
    }, [isHidden]);
    useEffect(() => () => clearTimeout(timeoutRef.current), []);

    if (v2) {
        return (
            <div className={b({isHidden}, [className])} onClick={isHidden ? onClick : undefined}>
                <div className={b('head')}>
                    <SectionHead icon={icon}>{title}</SectionHead>
                    <div className={b('arrow')} onClick={!isHidden ? onClick : undefined} />
                </div>

                <div
                    className={b('content')}
                    style={{maxHeight: height !== '' && height, overflow: isOverflowHidden && 'hidden'}}
                    ref={contentRef}
                >
                    {children}
                </div>
            </div>
        );
    }

    return (
        <div className={className}>
            <SectionHead icon={icon}>{title}</SectionHead>
            {children}
        </div>
    );
};

Section.propTypes = {
    className: PropTypes.string,
    isHiddenDefault: PropTypes.bool,
    title: PropTypes.string.isRequired,
    children: PropTypes.node.isRequired,
    icon: PropTypes.string.isRequired
};
