import React from 'react';
import {useSelector} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('SectionHead');

export default function SectionHead({children, icon}) {
    const v2 = useSelector(({common = {}}) => common.v2 || false);

    return (
        <div className={b({v2, v1: !v2})}>
            <div className={b('icon', v2 ? {[icon]: true} : [`p-icon__${icon}`])} />
            <div className={b('title')}>{children}</div>
        </div>
    );
}

SectionHead.propTypes = {
    children: PropTypes.oneOfType([PropTypes.string, PropTypes.node, PropTypes.element]).isRequired,
    icon: PropTypes.string.isRequired
};
