import {push} from 'react-router-redux';
import {setEditMode} from '../../../common/actions';

/* eslint-disable no-invalid-this */

export const link = '/profile/social';

export function addProfiles(e) {
    e.preventDefault();

    if (this.props.settings.isTouch) {
        this.props.dispatch(push(link));
    } else {
        this.props.dispatch(setEditMode('social'));
    }
}

export function sortProfiles(profiles) {
    if (!(profiles || []).length) {
        return null;
    }

    return profiles.reduce((acc, cur) => {
        if (!acc.hasOwnProperty(cur.provider.code)) {
            acc[cur.provider.code] = []; // eslint-disable-line no-param-reassign
        }

        acc[cur.provider.code].push(cur);

        return acc;
    }, {});
}
