import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Link} from '@components/Link';
import Modal from '@components/Wrappers/Modal.jsx';

import {Section} from '@blocks/morda/new/section/section.jsx';
import SocialProfile from './social_profile/social_profile.jsx';
import SocialModal from '@blocks/morda/social_info/modal/modal.jsx';

import {withUpdater} from '@blocks/hocs/withContext';

import metrics from '@blocks/metrics';

import * as extracted from './social_block.js';
import {setEditMode} from '@blocks/common/actions';
import {showAllSettings} from '@blocks/morda/social_info/actions';

export class SocialBlock extends React.Component {
    static sendEditMetrics() {
        metrics.send('Социальные сети: Редактировать');
    }
    static sendAddMetrics() {
        metrics.send('Социальные сети: Привязать профиль');
    }

    constructor(props) {
        super(props);

        const {profiles = []} = props.social;

        this.addProfiles = extracted.addProfiles.bind(this);
        this.addProfilesLink = ( // eslint-disable-line no-extra-parens
            <span onClick={SocialBlock.sendAddMetrics}>
                <Link href={extracted.link} onClick={this.addProfiles}>
                    {i18n('Profile2.add.account')}
                </Link>
            </span>
        );

        this.profiles = extracted.sortProfiles(profiles);
    }

    componentWillReceiveProps(nextProps) {
        if (!this.profiles || (nextProps.social.profiles || []).length !== this.profiles.length) {
            this.profiles = extracted.sortProfiles(nextProps.social.profiles);
        }
    }

    closeModal = () => {
        const {dispatch} = this.props;

        dispatch(setEditMode(null));
        dispatch(showAllSettings(null));
    };

    render() {
        const {dispatch, settings, social, access, common, person} = this.props;

        let counter = 0;

        return (
            <Section className='p-social' icon='social' title={i18n('Profile2.titles.social')} isHiddenDefault={true}>
                {this.profiles ? (
                    <div>
                        {this.profiles &&
                            Object.keys(this.profiles).map((code) => (
                                <div
                                    className={classnames('s-block s-block__margin_mobile', {
                                        's-block__margin': ++counter % 3 !== 0
                                    })}
                                    key={code}
                                >
                                    <div className='soc-profile__block'>
                                        <SocialProfile
                                            providerCode={code}
                                            dispatch={dispatch}
                                            profiles={this.profiles[code]}
                                            isTouch={settings.isTouch}
                                            sendMetrics={SocialBlock.sendEditMetrics}
                                            onClick={this.addProfiles}
                                        />
                                    </div>
                                </div>
                            ))}
                        <div
                            className={classnames('s-block s-block__margin_mobile', {
                                's-block__margin': ++counter % 3 !== 0
                            })}
                        >
                            <div className='soc-profile__block'>
                                <div className='s-block__sub p-mobile_hidden' />
                                <div className='s-block__sub s-block__sub_hl'>{this.addProfilesLink}</div>
                            </div>
                        </div>
                    </div>
                ) : (
                    <div className='soc-profile__block'>
                        <div className='s-block__sub s-block__sub_hl'>{this.addProfilesLink}</div>
                        <div className='s-block__sub'>{i18n('Profile2.social.desc')}</div>
                    </div>
                )}
                <Modal visible={common.edit === 'social'} onCloserClick={this.closeModal} dataT='social-block'>
                    <SocialModal
                        dispatch={dispatch}
                        settings={settings}
                        social={social}
                        access={access}
                        common={common}
                        person={person}
                        is2faEnabled={access.is2faEnabled}
                        passwordStrength={(access.passwordInfo || {}).strength}
                        retpath={common.retpath}
                        modal={true}
                    />
                </Modal>
            </Section>
        );
    }
}

SocialBlock.propTypes = {
    dispatch: PropTypes.func.isRequired,
    settings: PropTypes.object.isRequired,
    social: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    common: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired
};

export default withUpdater(SocialBlock, 'social', 'common.edit');
